#ifndef _BOAT_H
#define _BOAT_H

#include "moveable.h"
#include "builder.h"
#include "individual.h"

class Boat : public Moveable
{
public:

   Boat(char *the_name, char *the_area);
   virtual ~Boat();

   char    *get_move_str();
   void    set_move_str(char *new_str);
   char    *get_water_brief();
   void    set_water_brief(char *new_str);

   char    *get_brief();

   int   read_boat_attrib(FILE *read_file, char *areaname, ErrLog *error_log);

   int     enter_boat(Player *the_player);
   int     exit_boat(Player *the_player);
   int     get_passengers(Individual *the_ind, Strings *the_string);
   int     stop_passengers_fighting(void);
   int     move_location(Location *new_loc);
   int     contains_players(void);

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

   Boat    *operator = (Boat *copy_from); 

private:

   Boat();
   Strings move_str;
   Strings water_brief;

};

#endif
