/* Mime.h - Declarations for af's MIME header handling.
   Copyright (C) 1994 - 2003 Malc Arnold.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/****************************************************************************/
/* RCS info */

#define	MIMEID		"$Id: mime.h,v 2.6 2003/10/27 23:16:20 malc Exp $"

/****************************************************************************/
/* The structures used to store a parsed Content-Type */

typedef struct mimeparam {
	char *name, *value;		/* Parameter name and value */
	struct mimeparam *next;		/* Pointer to next parameter */
} MIMEPARAM;

typedef struct {
	char *type, *subtype;		/* MIME type and subtype */
	MIMEPARAM *params;		/* Parameters */
} MIMETYPE;

/****************************************************************************/
/* The structures used when rebuilding a partial message */

typedef struct message_part {
	int number, total;		/* The part number and total */
	MESSAGE *message;		/* The message containing the part */
	struct message_part *parts;	/* Parts containing the part */
	struct message_part *next;	/* The next part in the list */
} MESSAGE_PART;

typedef struct partial_id {
	char *partial_id;		/* The id for this partial message */
	struct partial_id *next;	/* The next id in the list */
} PARTIAL_ID;

/****************************************************************************/
/* The options which can be passed when encoding or decoding words */

#define WR_NONE		00
#define WR_SHOW		01
#define WR_FOLD		02
#define WR_UNFOLD	04

/****************************************************************************/
/* The possible types of body-part expansion */

#define BE_NORMAL	0
#define BE_MESSAGE	1
#define BE_DIGEST	2
#define BE_BODY_PART	3

/****************************************************************************/
/* The valid MIME encodings, used for completion */
  
#define ENCODINGS	{ "7bit", "8bit", "quoted-printable", "base64", NULL }
  
/****************************************************************************/
/* The MIME Encodings which af knows how to decode */

#define VALID_ENCODINGS	{ "7bit", "8bit", "base64", "binary", \
	  		  "quoted-printable", "x-uue", "x-uuencode", NULL }

/****************************************************************************/
/* The Content-Types af can handle internally */

#define VIEWABLE_TYPES	{ "text/plain", "multipart/mixed", \
	  		  "multipart/digest", "multipart/alternative", \
			  "multipart/parallel", "message/rfc822", \
			  "message/news", "message/partial", NULL }

/****************************************************************************/
/* The MIME-Version we expect to see */

#define VERSION_VALUE		"1.0"

/* Definitions for textual messages */

#define TEXT_TYPE		"text"
#define PLAIN_SUBTYPE		"plain"
#define CHARSET_PARAM		"charset"
#define US_ASCII		"us-ascii"

/* Definitions for multipart messages */

#define MULTIPART_TYPE		"multipart"
#define MIXED_SUBTYPE		"mixed"
#define DIGEST_SUBTYPE		"digest"
#define ALTERNATIVE_SUBTYPE	"alternative"
#define PARALLEL_SUBTYPE	"parallel"
#define BOUNDARY_PARAM		"boundary"
#define BOUNDARY_DELIM		"--"

/* Definitions for non-MIME digests */

#define RFC934_DELIM		"-"
#define RFC934_ESCAPE		"- "
#define RFC1153_START_LEN	60
#define RFC1153_START		"------------------------------\
------------------------------------------"
#define RFC1153_DELIM		"------------------------------\n"

/* Definitions for message messages */

#define MESSAGE_TYPE		"message"
#define RFC822_SUBTYPE		"rfc822"
#define NEWS_SUBTYPE		"news"
#define PARTIAL_SUBTYPE		"partial"
#define EXTERNAL_SUBTYPE	"external-body"
#define ID_PARAM		"id"
#define NUMBER_PARAM		"number"
#define TOTAL_PARAM		"total"

/* Definitions for application messages */

#define APPLICATION_TYPE	"application"
#define OCTET_STREAM_SUBTYPE	"octet-stream"

/* Definitions for Content-Dispositions */

#define INLINE_DISP		"inline"
#define ATTACHMENT_DISP		"attachment"
#define FILENAME_PARAM		"filename"

/* And the wildcard character in a mailcap entry */

#define MCAP_WILDCARD		"*"

/****************************************************************************/
/* The MIME encodings that af knows how to deal with */

#define SEVEN_BIT		"7bit"
#define EIGHT_BIT		"8bit"
#define BINARY			"binary"
#define QUOTED_PRINTABLE	"quoted-printable"
#define BASE64			"base64"
#define X_UUE			"x-uue"
#define X_UUENCODE		"x-uuencode"

/****************************************************************************/
/* The possible reasons for encoding text */

#define ENCODE_NONE	000
#define ENCODE_8BIT	001
#define ENCODE_BINARY	002
#define ENCODE_SPACES	004
#define ENCODE_FOLD	010
#define ENCODE_SMTP	020
#define ENCODE_BASE64	040

/****************************************************************************/
/* Definitions for the quoted-printable encoding */

#define QP_ESC_LEN		3
#define QP_ESC_CHAR		'='
#define QP_LINE_LENGTH		76
#define QP_LINE_BREAK		"=\n"

/* And a macro to get the value of a QP digit */

#define QP_VALUE(x)		((isdigit(x)) ? (x) - '0' : \
				 (isupper(x) && (x) <= 'F') \
				 ? (x) - 'A' + 10 : \
				 (islower(x) && (x) <= 'f') \
				 ? (x) - 'a' + 10 : -1)

/****************************************************************************/
/* Definitions for the base64 encoding */

#define B64_PAD_CHAR		'='
#define B64_TLENGTH		3
#define B64_ELENGTH		4
#define B64_LINE_LENGTH		72

/* A macro to convert between encoded and decoded base64 lengths */

#define B64_ENCODED_LEN(x)	((((x) - 1) % 3 + 1) * 4)
#define B64_DECODED_LEN(x)	(((x) % 4) * 3)

/* And a macro to get the value of a base64 character */

#define B64_VALUE(x)		((isupper(x)) ? (x) - 'A' : \
				 (islower(x)) ? (x) - 'a' + 26 : \
				 (isdigit(x)) ? (x) - '0' + 52 : \
				 ((x) == '+') ? 62 : ((x) == '/') ? 63 : -1)

/****************************************************************************/
/* Definitions for the (obsolete) uuencode encoding */

#define UUE_TLENGTH		3
#define UUE_ELENGTH		4
#define UUE_BASE_CHAR		' '
#define UUE_MAX_VALUE		64
#define UUE_BEGIN		"begin "
#define UUE_END			"end\n"
#define UUE_BLANK		" \n"
#define UUE_LINE_LEN		45

/****************************************************************************/
/* Definitions for handling rfc1522 encoded-words */

#define EW_DELIMITER		'?'
#define EW_TERMINATOR		'='
#define EW_NOEWORD		"?_"
#define EW_NOCOMMENT		"\"()?\\_"
#define EW_NOPHRASE		"\"#$%&'(),.:;<>?@[\\]^_`{|}~"
#define EW_NOENCODE		"#$&'?_`{|}~"
#define EW_SPACE		' '
#define EW_USCORE		'_'
#define EW_QP			"Q"
#define EW_B64			"B"

/* And lengths related to encoded-words */

#define EW_FORMLEN		7
#define EW_MAX_LEN		70

/****************************************************************************/
/* Definitions related to charset directives */

#define CD_MIN_LEN		7
#define CD_TERM_LEN		3
#define CD_START		"(**"
#define CD_END			"**)"

/****************************************************************************/
