#
# Module:     GroupAdd.pm  
# Date:       03/05/04  
# Version:    1.15  
# Edited by:  teon@teon.org  
# Description:  
#
#  This plugin, provides same functionality, as groupadd program (in
#  fact, it uses groupadd).  
#
# License: 
# 
#  This program is free software; you can redistribute it and/or modify 
#  it under the terms of the GNU General Public License Version 2 as 
#  published by the Free Software Foundation. 
# 
#  This program is distributed in the hope that it will be useful, 
#  but WITHOUT ANY WARRANTY; without even the implied warranty of 
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
#  GNU General Public License for more details. 
# 
#  You should have received a copy of the GNU General Public License 
#  along with this program; if not, write to the Free Software 
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
#  USA. 
# 
# This file is part of adduser-ng program. 
# 
# Copyright (C) 2003-2004 Bartosz Oler <liar@bzimage.us> 
# Copyright (C) 2003-2004 Robert Olejnik <teon@teon.org> 
#

package AddUser::plugins::GroupAdd;

use strict;
use AddUser::StdLib;

my $_PLUGIN = 'GroupAdd';
my $_APIVERSION = 0x1;

# new
# {{{

sub new {
	my ($c, %args) = @_;
	my $class = ref($c) || $c;

	$args{opts} = {
		'group_name' => '',
		'gid' => '',
		'allow_duplicate_gid' => 'no'};

        $args{APIVERSION} = $_APIVERSION;
        $args{NAME} = $_PLUGIN;

        bless \%args, $class;
}

# }}}




# configure
# =========
#
# {{{

sub configure {
	my $self     = shift;
        my $conf     = $self->{plugins_options}{GroupConfig};
        my $ui       = $self->{plugins_options}{UI};
        my $verbose  = $self->{plugins_options}{verbose};
        my $keywords = $self->{plugins_options}{keywords};
	my $docs     = &get_documentation($self->{plugins_options}{documentation_dir}, $_PLUGIN);

        my $value;

	$self->{plugins_options}{docs} = $docs->{options}{option};
	$ui->display("$_PLUGIN", $docs->{description}."\n") if $verbose;

	wrapper_getlong($self, $_PLUGIN, 'group_name');
	wrapper_getlong($self, $_PLUGIN, 'gid');
	wrapper_getsingle($self, $_PLUGIN, 'allow_duplicate_gid', ('no', 'yes'));

	open(FH, '<', '/etc/group') || return $ERRNO{'ERROR'};
	if (scalar(grep {/^$self->{opts}{group_name}:/} <FH>)) {
		close FH;
		return $ERRNO{'DONE'};
	}
	close FH;

	return $ERRNO{'OK'};
}

# }}}




# execute
# =======
#
# {{{

sub execute {
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};

        my @cmd;

	if ($self->{opts}{gid}) {
		push(@cmd, ('-g', $self->{opts}{gid}));
	}
	if ($self->{opts}{allow_duplicate_gid} eq 'yes') {
		push(@cmd, '-o');
	}

        push(@cmd, $self->{opts}{group_name});

	$ui->display("Command to run", "groupadd ".join " ", @cmd) if $verbose;

	if (system("groupadd", @cmd) == 0) {
		return $ERRNO{'OK'};
	} else {
		return $ERRNO{'ERROR'};
	}
}

# }}}


# rollback
# ========
#
# {{{

sub rollback {
	my $self    = shift;
        my $conf    = $self->{plugins_options}{GroupConfig};
        my $ui      = $self->{plugins_options}{UI};
        my $verbose = $self->{plugins_options}{verbose};

	$ui->display("Rollback...", "Doing a rollback.");

	system("groupdel", $self->{opts}{group_name});

	#
	# We don't care about result of the rollback.
	#
	return $ERRNO{'OK'};
}

# }}}

1;
