// Free_List.cpp,v 1.19 2004/06/16 07:57:20 jwillemsen Exp

#ifndef ACE_FREE_LIST_C
#define ACE_FREE_LIST_C

#include "ace/Free_List.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#if !defined (__ACE_INLINE__)
#include "ace/Free_List.inl"
#endif /* __ACE_INLINE__ */

ACE_RCSID(ace, Free_List, "Free_List.cpp,v 1.19 2004/06/16 07:57:20 jwillemsen Exp")

// Empty constructor

template <class T>
ACE_Free_List<T>::~ACE_Free_List (void)
{
  // Nothing
}

// Default constructor that takes in a preallocation number
// (<prealloc>), a low and high water mark (<lwm> and <hwm>) and an
// increment value (<inc>)

template <class T, class ACE_LOCK>
ACE_Locked_Free_List<T, ACE_LOCK>::ACE_Locked_Free_List (int mode,
                                                     size_t prealloc,
                                                     size_t lwm,
                                                     size_t hwm,
                                                     size_t inc)
  : mode_ (mode),
    free_list_ (0),
    lwm_ (lwm),
    hwm_ (hwm),
    inc_ (inc),
    size_ (0)
{
  this->alloc (prealloc);
}

// Destructor - removes all the elements from the free_list

template <class T, class ACE_LOCK>
ACE_Locked_Free_List<T, ACE_LOCK>::~ACE_Locked_Free_List (void)
{
  if (this->mode_ != ACE_PURE_FREE_LIST)
    while (this->free_list_ != 0)
      {
        T *temp = this->free_list_;
        this->free_list_ = this->free_list_->get_next ();
        delete temp;
      }
}

// Allocates <n> extra nodes for the freelist

template <class T, class ACE_LOCK> void
ACE_Locked_Free_List<T, ACE_LOCK>::alloc (size_t n)
{
  for (; n > 0; n--)
    {
      T *temp = 0;
      ACE_NEW (temp, T);
      temp->set_next (this->free_list_);
      this->free_list_ = temp;
      this->size_++;
    }
}

// Removes and frees <n> nodes from the freelist.

template <class T, class ACE_LOCK> void
ACE_Locked_Free_List<T, ACE_LOCK>::dealloc (size_t n)
{
  for (; this->free_list_ != 0 && n > 0;
       n--)
    {
      T *temp = this->free_list_;
      this->free_list_ = this->free_list_->get_next ();
      delete temp;
      this->size_--;
    }
}

#endif /* ACE_FREE_LIST_C */
