// SequencePushSupplier.cpp,v 1.4 2003/08/24 13:50:14 jwillemsen Exp

#include "SequencePushSupplier.h"

#if ! defined (__ACE_INLINE__)
#include "SequencePushSupplier.inl"
#endif /* __ACE_INLINE__ */

ACE_RCSID(lib, TAO_SequencePushSupplier, "SequencePushSupplier.cpp,v 1.4 2003/08/24 13:50:14 jwillemsen Exp")

TAO_Notify_Tests_SequencePushSupplier_Traits::TAO_Notify_Tests_SequencePushSupplier_Traits (void)
  :type_ (CosNotifyChannelAdmin::SEQUENCE_EVENT)
{
}

/*******************************************************************/

TAO_Notify_Tests_SequencePushSupplier::TAO_Notify_Tests_SequencePushSupplier (void)
{
}

TAO_Notify_Tests_SequencePushSupplier::~TAO_Notify_Tests_SequencePushSupplier ()
{
}

void
TAO_Notify_Tests_SequencePushSupplier::send_events (const CosNotification::EventBatch& events
                                          ACE_ENV_ARG_DECL
                                          )
{
  ACE_ASSERT (!CORBA::is_nil (this->proxy_.in ()));

  this->proxy_->push_structured_events (events ACE_ENV_ARG_PARAMETER);
}

void
TAO_Notify_Tests_SequencePushSupplier::connect_to_peer (Proxy_Traits::PTR proxy_ptr, Peer_Traits::PTR peer_ptr ACE_ENV_ARG_DECL)
{
  proxy_ptr->connect_sequence_push_supplier (peer_ptr
                                               ACE_ENV_ARG_PARAMETER);
}

void
TAO_Notify_Tests_SequencePushSupplier::disconnect_from_proxy (ACE_ENV_SINGLE_ARG_DECL)
{
  this->proxy_->disconnect_sequence_push_consumer (ACE_ENV_SINGLE_ARG_PARAMETER);
}

void
TAO_Notify_Tests_SequencePushSupplier::disconnect_sequence_push_supplier (ACE_ENV_SINGLE_ARG_DECL)
  ACE_THROW_SPEC ((CORBA::SystemException))
{
  this->deactivate (ACE_ENV_SINGLE_ARG_PARAMETER);
}


#if defined (ACE_HAS_EXPLICIT_TEMPLATE_INSTANTIATION)

template class TAO_Notify_Tests_Peer_T<TAO_Notify_Tests_SequencePushSupplier_Traits>;
template class TAO_Notify_Tests_Supplier_T<TAO_Notify_Tests_SequencePushSupplier_Traits>;

#elif defined (ACE_HAS_TEMPLATE_INSTANTIATION_PRAGMA)

#pragma instantiate TAO_Notify_Tests_Peer_T<TAO_Notify_Tests_SequencePushSupplier_Traits>
#pragma instantiate TAO_Notify_Tests_Supplier_T<TAO_Notify_Tests_SequencePushSupplier_Traits>

#endif /*ACE_HAS_EXPLICIT_TEMPLATE_INSTANTIATION */
