/* -*- C++ -*- */
// Notify_Push_Consumer.h,v 1.4 2003/07/06 21:41:57 pradeep Exp
// ==========================================================================
//
// = LIBRARY
//   TAO/orbsvcs/tests/Notify/Structured_Filter
//
// = FILENAME
//   Notify_Push_Consumer.h
//
// = DESCRIPTION
//   A structured push consumer implementation.
//
// = AUTHOR
//    Chip Jones <jones_c@ociweb.com>
//
// ==========================================================================
#ifndef NOTIFY_PUSH_CONSUMER_H
#define NOTIFY_PUSH_CONSUMER_H

#include "Notify_StructuredPushConsumer.h"


class Notify_Push_Consumer: public TAO_Notify_Tests_StructuredPushConsumer
{
public:
  Notify_Push_Consumer (const char* name);

  void _connect (CosNotifyChannelAdmin::ConsumerAdmin_ptr consumer_admin,
                CosNotifyChannelAdmin::EventChannel_ptr ec,
                CORBA::Boolean isFilter
                ACE_ENV_ARG_DECL)
    ACE_THROW_SPEC ((CORBA::SystemException));

  static CORBA::Short get_count ();

private:
  void push_structured_event (const CosNotification::StructuredEvent&
                              ACE_ENV_ARG_DECL)
    ACE_THROW_SPEC ((CORBA::SystemException));

  static CORBA::Short event_count;
  ACE_CString name_;
};

#endif /* NOTIFY_PUSH_SUPPLIER_H */
