// RoundTrip_exec.h,v 1.1 2004/07/01 20:29:32 jai Exp

//============================================================
/**
 * @file RoundTrip_exec.h
 *
 * Header file for the Executor implementation.
 *
 *  @author Arvind S. Krishna <arvindk@dre.vanderbilt.edu>
 */
//============================================================

#ifndef NODEAPP_ROUNDTRIP_EXEC_H
#define NODEAPP_ROUNDTRIP_EXEC_H

#include "NodeAppTest_RoundTripEC.h"
#include "RoundTrip_exec_export.h"
#include "tao/LocalObject.h"

namespace RoundTrip_Impl
{

  /**
   * @class RoundTrip_exec_i
   *
   * RoundTrip executor implementation class.
   */

  class NODEAPPTEST_ROUNDTRIP_EXEC_Export RoundTrip_exec_i :
    public virtual NodeAppTest::LatencyTest,
    public virtual RoundTrip_Impl::RoundTrip_Exec,
    public virtual TAO_Local_RefCounted_Object
  {

  public:
    /// Default constructor.
    RoundTrip_exec_i ();

    /// Default destructor.
      ~RoundTrip_exec_i ();

    /// Operation to test the data
      virtual CORBA::Long cube_long (CORBA::Long data)
        ACE_THROW_SPEC ((CORBA::SystemException));

    /*
    virtual ::NodeAppTest::CCM_LatencyTest*
                        get_latency (ACE_ENV_SINGLE_ARG_DECL)
                ACE_THROW_SPEC ((CORBA::SystemException));
    */

      NodeAppTest::CCM_LatencyTest_ptr
      get_facet_1(ACE_ENV_SINGLE_ARG_DECL)
	ACE_THROW_SPEC ((CORBA::SystemException));


      NodeAppTest::CCM_LatencyTest_ptr
      get_facet_2(ACE_ENV_SINGLE_ARG_DECL)
	ACE_THROW_SPEC ((CORBA::SystemException));

    // Operations from Components::SessionComponent
      virtual void set_session_context (Components::SessionContext_ptr ctx
					ACE_ENV_ARG_DECL_WITH_DEFAULTS)
	ACE_THROW_SPEC ((CORBA::SystemException,
			 Components::CCMException));

      virtual void ccm_activate (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS)
	ACE_THROW_SPEC ((CORBA::SystemException,
			 Components::CCMException));

      virtual void ccm_passivate (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS)
	ACE_THROW_SPEC ((CORBA::SystemException,
			 Components::CCMException));

      virtual void ccm_remove (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS)
	ACE_THROW_SPEC ((CORBA::SystemException,
			 Components::CCMException));

    /// Helper function to be called back by timeout_Handler
      void pulse (void);

    // CIAO defined methods
      virtual void ciao_preactivate (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS)
	ACE_THROW_SPEC ((CORBA::SystemException,
			 Components::CCMException));

      virtual void ciao_postactivate (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS)
	ACE_THROW_SPEC ((CORBA::SystemException,
			 Components::CCMException));
  };

  //
  //
  //
  class LatencyTest_Impl : public virtual NodeAppTest::CCM_LatencyTest,
                           public virtual TAO_Local_RefCounted_Object
  {
  public:
    LatencyTest_Impl ()
    {
    }

    virtual CORBA::Long cube_long (CORBA::Long data)
        ACE_THROW_SPEC ((CORBA::SystemException));
  };

  /**
   * @class RoundTripHome_exec_i
   *
   * RoundTrip home executor implementation class.
   */
  class NODEAPPTEST_ROUNDTRIP_EXEC_Export RoundTripHome_exec_i :
    public virtual RoundTrip_Impl::RoundTripHome_Exec,
    public virtual TAO_Local_RefCounted_Object
  {
  public:
    /// Default ctor.
    RoundTripHome_exec_i ();

    /// Default dtor.
    ~RoundTripHome_exec_i ();

    // Implicit home operations.

    virtual ::Components::EnterpriseComponent_ptr
    create (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS)
      ACE_THROW_SPEC ((CORBA::SystemException,
                       Components::CCMException));
  };

}

extern "C" NODEAPPTEST_ROUNDTRIP_EXEC_Export
::Components::HomeExecutorBase_ptr createRoundTripHome_Impl (void);

#endif /* NODEAPP_ROUNDTRIPGEN_EXEC_H */
