// file      : CCF/IDL2/Traversal/Attribute.hpp
// author    : Boris Kolpackov <boris@dre.vanderbilt.edu>
// cvs-id    : Attribute.hpp,v 1.3 2004/01/02 20:39:28 boris Exp

#ifndef CCF_IDL2_TRAVERSAL_ATTRIBUTE_HPP
#define CCF_IDL2_TRAVERSAL_ATTRIBUTE_HPP

#include "CCF/IDL2/SemanticGraph/Attribute.hpp"
#include "CCF/IDL2/Traversal/Elements.hpp"

namespace CCF
{
  namespace IDL2
  {
    namespace Traversal
    {
      //
      //
      //
      struct Attribute : Node<SemanticGraph::Attribute>
      {
        virtual void
        traverse (Type&);

        virtual void
        pre (Type&);

        virtual void
        belongs (Type&, EdgeDispatcherBase&);

        virtual void
        belongs (Type&);

        virtual void
        name (Type&);

        virtual void
        post (Type&);
      };

      //
      //
      //
      struct ReadAttribute : Node<SemanticGraph::ReadAttribute>
      {
        virtual void
        traverse (Type&);

        virtual void
        pre (Type&);

        virtual void
        belongs (Type&, EdgeDispatcherBase&);

        virtual void
        belongs (Type&);

        virtual void
        name (Type&);

        /*
        virtual void
        get_raises (Type&, EdgeDispatcherBase&);

        virtual void
        get_raises (Type&);

        virtual void
        get_raises_pre (Type&);

        virtual void
        get_raises_post (Type&);
        */

        virtual void
        post (Type&);
      };


      //
      //
      //
      struct ReadWriteAttribute : Node<SemanticGraph::ReadWriteAttribute>
      {
        virtual void
        traverse (Type&);

        virtual void
        pre (Type&);

        virtual void
        belongs (Type&, EdgeDispatcherBase&);

        virtual void
        belongs (Type&);

        virtual void
        name (Type&);

        /*
        virtual void
        get_raises (Type&, EdgeDispatcherBase&);

        virtual void
        get_raises (Type&);

        virtual void
        get_raises_pre (Type&);

        virtual void
        get_raises_post (Type&);

        virtual void
        set_raises (Type&, EdgeDispatcherBase&);

        virtual void
        set_raises (Type&);

        virtual void
        set_raises_pre (Type&);

        virtual void
        set_raises_post (Type&);
        */

        virtual void
        post (Type&);
      };
    }
  }
}

#endif  // CCF_IDL2_TRAVERSAL_ATTRIBUTE_HPP
