// file      : CCF/IDL2/SemanticAction/Impl/Exception.cpp
// author    : Boris Kolpackov <boris@dre.vanderbilt.edu>
// cvs-id    : Exception.cpp,v 1.2 2004/01/01 00:12:30 boris Exp

#include "CCF/IDL2/SemanticAction/Impl/Exception.hpp"

#include <iostream>

using std::cerr;
using std::endl;

namespace CCF
{
  namespace IDL2
  {
    namespace SemanticAction
    {
      namespace Impl
      {
        using namespace SemanticGraph;

        Exception::
        Exception (Context& c)
            : ScopeBase<SemanticGraph::Exception> (c)
        {
        }

        void Exception::
        begin (SimpleIdentifierPtr const& id)
        {
          if (ctx.trace ()) cerr << "exception " << id << endl;

          SimpleName name (id->lexeme ());

          //@@ Need to check for redeclaration of the name. Can not
          //   do that because I don't have mechanism for throwing
          //   exception from SA.
          //
          now (ctx.tu ().new_node<SemanticGraph::Exception> ());
          ctx.tu ().new_edge<Defines> (ctx.scope (), now (), name);
        }

        void Exception::
        open_scope ()
        {
          if (ctx.trace ()) cerr << "scope open" << endl;

          push (ctx.scope ());
          ctx.scope (now ());
        }

        void Exception::
        close_scope ()
        {
          ctx.scope (top ());
          pop ();

          if (ctx.trace ()) cerr << "scope close" << endl;
        }

        void Exception::
        end ()
        {
          if (ctx.trace ()) cerr << "end" << endl;
        }
      }
    }
  }
}
