/*
 * $Id: Chap0613.java,v 1.3 2003/06/25 07:36:33 blowagie Exp $
 * $Name:  $
 *
 * This code is free software. It may only be copied or modified
 * if you include the following copyright notice:
 *
 * --> Copyright 2002 by Paulo Soares <--
 *
 * This code is part of the 'iText Tutorial'.
 * You can find the complete tutorial at the following address:
 * http://www.lowagie.com/iText/tutorial/
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * itext-questions@lists.sourceforge.net
 */

import java.io.*;
import com.lowagie.text.*;
import com.lowagie.text.pdf.*;

public class Chap0613 {
    
    
    public static void main(String[] args) {
        System.out.println("Chapter 6 example 13: masked images");
        
        Document document = new Document(PageSize.A4, 50, 50, 50, 50);
        try {
            PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream("Chap0613.pdf"));
            
            document.open();
            Paragraph p = new Paragraph("Some text behind a masked image.");
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            document.add(p);
            PdfContentByte cb = writer.getDirectContent();
            byte maskr[] = {(byte)0x3c, (byte)0x7e, (byte)0xe7, (byte)0xc3, (byte)0xc3, (byte)0xe7, (byte)0x7e, (byte)0x3c};
            Image mask = Image.getInstance(8, 8, 1, 1, maskr);
            mask.makeMask();
            mask.setInvertMask(true);
            Image image = Image.getInstance("vonnegut.gif");
            image.setImageMask(mask);
            image.setAbsolutePosition(60, 620);
            // explicit masking
            cb.addImage(image);
            // stencil masking
            cb.setRGBColorFill(255, 0, 0);
            cb.addImage(mask, mask.scaledWidth() * 8, 0, 0, mask.scaledHeight() * 8, 100, 400);
            cb.setRGBColorFill(0, 255, 0);
            cb.addImage(mask, mask.scaledWidth() * 8, 0, 0, mask.scaledHeight() * 8, 200, 400);
            cb.setRGBColorFill(0, 0, 255);
            cb.addImage(mask, mask.scaledWidth() * 8, 0, 0, mask.scaledHeight() * 8, 300, 400);
            document.close();
        }
        catch (Exception de) {
            de.printStackTrace();
        }
    }
}
