
#define SND_MAGIC 0x2E736E64

#define SND_FORMAT_UNSPECIFIED  0
#define SND_FORMAT_MULAW_8 1      
#define SND_FORMAT_LINEAR_8 2    
#define SND_FORMAT_LINEAR_16 3
#define SND_FORMAT_LINEAR_24 4
#define SND_FORMAT_LINEAR_32 5
#define SND_FORMAT_FLOAT 6
#define SND_FORMAT_DOUBLE 7
#define SND_FORMAT_INDIRECT 8
#define SND_FORMAT_NESTED 9
#define SND_FORMAT_DSP_CORE 10
#define SND_FORMAT_DSP_DATA_8 11
#define SND_FORMAT_DSP_DATA_16 12
#define SND_FORMAT_DSP_DATA_24 13
#define SND_FORMAT_DSP_DATA_32 14
#define SND_FORMAT_DSP_UNKNOWN 15
#define SND_FORMAT_DISPLAY 16      
#define SND_FORMAT_MULAW_SQUELCH 17        
#define SND_FORMAT_EMPHASIZED 18 
#define SND_FORMAT_COMPRESSED 19
#define SND_FORMAT_COMPRESSED_EMPHASIZED 20
#define SND_FORMAT_DSP_COMMANDS 21
#define SND_FORMAT_DSP_COMMANDS_SAMPLES 22

typedef struct {
   int magic;               /* magic number SND_MAGIC */
   int dataLocation;        /* offset or pointer to the data */
   int dataSize;            /* number of bytes of data */
   int dataFormat;          /* the data format code */
   int samplingRate;        /* the sampling rate */
   int channelCount;        /* the number of channels */
} SNDSoundStruct;

bool is_au(int);
int au_open(Audio_File *,int);
int au_read(Audio_File,char *,int);
int au_write(Audio_File,char *,int);
int au_seek(Audio_File,int,int);
int au_close(Audio_File);

   
   
