// $Id: StationRef.hh,v 1.2 2002/10/01 18:04:31 flaterco Exp $
/*  StationRef  Index information for a station in a harmonics file.

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class Station;
class TideContext;

class StationRef {
public:
  StationRef();
  virtual ~StationRef();
  Dstr name;
  Coordinates coordinates;
  Dstr *harmonicsFileName;
  Dstr timezone;
  Dstr note;

  void shortHarmonicsFileName (Dstr &text_out);

  virtual Station *load (TideContext *in_context) = 0;
  virtual int is_reference_station() const = 0;
};

class ReferenceStationRef: public StationRef {
public:
  long filePosition;

  Station *load (TideContext *in_context);
  int is_reference_station() const;
};

class SubordinateStationRef: public StationRef {
public:
  Dstr source;
  ReferenceStationRef *rsr; // This is initialized to NULL in HarmonicsFile.
  Offsets *offsets;

  int is_reference_station() const;
  Station *load (TideContext *in_context);
};
