/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PLAYLIST_H
#define PLAYLIST_H

#include <qlist.h>
#include <qstring.h>
#include <qthread.h>

#include "PlaylistItem.h"
#include "tools/TextFile.h"

class Playlist : private TextFile
{
 public:
    Playlist();

    void lock();
    void unlock();

    // mutex protected
    
    bool load(const QString& newFileName);
    bool save();
    bool save(const QString& newFileName);
    
    void add(PlaylistItem*);
    void remove(uint pos);
    void clear();
    
    void findBaseDir();
    void removeBaseDir();
    void fixMissingInfo();

    void setCurrentPlayPos(uint pos);

    // not mutex protected
    
    void setModified();
    bool isModified() const;

    uint getCurrentPlayPos() const;

    bool haveFileName();
    const int getFormat() const  { return loadFormat; }

    void setMaxBasePrefix( const QString& );
   
    // These are public for easier access. It is assumed that
    // setModified() is called appropriately when these are
    // changed in a way which affects the list entries.
    QList<PlaylistItem> list;
    QString baseDir;
    
 private:
    QMutex listMutex;
    
    bool modified;
    uint currentPlayPos;
    QString fileName;
    QString maxBasePrefix;

    int loadFormat;
    const int saveFormat;
    
    static const char* const keys[];
    
    enum keyID
    {
        group_id, key_format, key_baseDir,
        // Format 1
        key_fileName, key_subsong,
        // Format 1 & 2
        key_time,
        // Format 2
        key_file, key_name, key_author, key_copyright, key_songs,
        key_subtune, key_fadeout
    };
};

#endif  /* PLAYLIST_H */
