/*-
# X-BASED RUBIK'S CUBE(tm)
#
#  RubikGLP.h
#
###
#
#  Copyright (c) 2003 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for RubikGL */

#ifndef _RubikGLP_h
#define _RubikGLP_h

#include "RubikGL.h"
#include <GL/gl.h>
#include <GL/glx.h>

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _RubikGLClassPart {
	int         ignore;
} RubikGLClassPart;

typedef struct _RubikGLClassRec {
	CoreClassPart core_class;
	RubikClassPart rubik_class;
	RubikGLClassPart rubikGL_class;
} RubikGLClassRec;

extern RubikGLClassRec rubikGLClassRec;
#endif

#define TR 8
#define BR 9
#define BL 10
#define TL 11
#define SAME 0
#define OPPOSITE 1
#define DOWN 0
#define UP 1
#define COORD3D 12
#define MAXVIEWS 2

#define AVSIZE ((w->rubik.sizex+w->rubik.sizey+w->rubik.sizez)/3.0)     /* Use of this should be minimized */
#define MAXSIZEX w->rubik.sizex
#define MAXSIZEY w->rubik.sizey
#define MAXSIZEZ w->rubik.sizez
#define MAXSIZEXY (w->rubik.sizex*w->rubik.sizey)
#define MAXSIZEYZ (w->rubik.sizey*w->rubik.sizez)
#define MAXSIZEZX (w->rubik.sizez*w->rubik.sizex)
#define LASTX (w->rubik.sizex-1)
#define LASTY (w->rubik.sizey-1)
#define LASTZ (w->rubik.sizez-1)
#define SCALE (2.1/AVSIZE)
/* These are not likely to change but... */
#define FIRSTX 0
#define FIRSTY 0
#define FIRSTZ 0
#define TOP_FACE 0
#define LEFT_FACE 1
#define FRONT_FACE 2
#define RIGHT_FACE 3
#define BOTTOM_FACE 4
#define BACK_FACE 5
#define NO_FACE (-1)
#define TEST_FACE (MAXFACES)
#define ERROR_FACE (MAXFACES+1)
#define NO_POSITION (-1)
#define NO_ROTATION (2*MAXORIENT)
#define NO_DEPTH MAXMAXSIZE
#define REVX(a) (MAXSIZEX-a-1)
#define REVY(a) (MAXSIZEY-a-1)
#define REVZ(a) (MAXSIZEZ-a-1)

#define CUBELEN 0.50
#define CUBEROUND (CUBELEN-0.05)
#define STICKERLONG (CUBEROUND-0.05)
#define STICKERSHORT (STICKERLONG-0.05)
#define STICKERDEPTH (CUBELEN+0.01)
#define CUT 0.04

typedef struct _RubikMove {
        int         face, direction;
        int         position;
} RubikMove;

typedef struct _RubikSlice {
        int         face, rotation;
        int         depth;
} RubikSlice;

typedef struct _RubikGLPart {
	double      angleStepX, angleStepY, angleStepZ, rotateStep;
	int         numTurnInc;
	Point       cubeSizex, cubeSizey, cubeSizez;
	RubikMove   movement;
	int step;
} RubikGLPart;

typedef struct _RubikGLRec {
	CorePart    core;
	RubikPart   rubik;
	RubikGLPart rubikGL;
} RubikGLRec;

extern Boolean SelectPiecesGL(RubikGLWidget w, int x, int y,
	int *face, int *position);
extern void DrawFrameGL(RubikGLWidget w, Boolean focus);
extern void DrawAllPiecesGL(RubikGLWidget w);
extern void MoveAllPiecesGL(RubikGLWidget w, int face, int direction,
	int fast);
extern void MovePiecesGL(RubikGLWidget w, int face, int position,
	int direction, Boolean control, int fast);

#endif /* _RubikGLP_h */
