/*-
# X-BASED OCTAHEDRON
#
#  Oct.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Oct */

#ifndef _XtOct_h
#define _XtOct_h

/***********************************************************************
 *
 * Oct Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNuserName ((char *) "userName")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNsize ((char *) "size")
#define XtNsticky ((char *) "sticky")
#define XtNmode ((char *) "mode")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNmenu ((char *) "menu")
#define XtNframeColor ((char *) "frameColor")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtNfaceColor6 ((char *) "faceColor6")
#define XtNfaceColor7 ((char *) "faceColor7")
#define XtCUserName ((char *) "UserName")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCSize ((char *) "Size")
#define XtCSticky ((char *) "Sticky")
#define XtCMode ((char *) "Mode")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCMenu ((char *) "Menu")

typedef struct _OctClassRec *OctWidgetClass;

extern WidgetClass octWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} octCallbackStruct;
#endif

#define OCT_HIDE (-8)
#define OCT_PRACTICE_QUERY (-7)
#define OCT_RANDOMIZE_QUERY (-6)
#define OCT_SOLVE_MESSAGE (-5)
#define OCT_RESTORE (-4)
#define OCT_RESET (-3)
#define OCT_AMBIGUOUS (-2)
#define OCT_ILLEGAL (-1)
#define OCT_MOVED 0
#define OCT_CONTROL 1
#define OCT_SOLVED 2
#define OCT_PRACTICE 3
#define OCT_RANDOMIZE 4
#define OCT_DEC 5
#define OCT_ORIENT 6
#define OCT_INC 7
#define OCT_PERIOD3 8
#define OCT_PERIOD4 9
#define OCT_BOTH 10
#define OCT_STICKY 11
#define OCT_COMPUTED 12
#define OCT_UNDO 13

#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#define MINFACETS 1
#define PERIOD3 3
#define PERIOD4 4
#define BOTH 5
#define MAXMODES 3
#define DEFAULTMODE PERIOD4
#define DEFAULTFACETS 3
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE FALSE
#define DEFAULTSTICKY FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

typedef struct _OctRec *OctWidget;

extern void intCat(char ** string, const char * var1, const int var2);
extern void stringCat(char ** string, const char * var1, const char * var2);

#endif /* _XtOct_h */
/* DON'T ADD STUFF AFTER THIS #endif */
