#/bin/sh
#
#
# Filename:   retype/rety-kbd.sh
# Created:  Fri Aug  8 00:04:38 CEST 2003
# 
# Description:
#
#  Test the Xnee functionality
#       replay recorded keyboard motions
#
#
 
 
 
 
# name of myself
MYNAME=rety-kbd.sh
 
 
# source useful funs
if [ ! -f etc/base_funs ]; 
then 
    echo "Can't find the file: base_funs"  
    echo "Start me up in the xnee test dir "
    exit
else 
    . etc/base_funs
fi 
 
init_test 
parse_me "$*"

#######################################################################

KEYBOARD_DEVICE=/dev/swkeybd





# main ..... I guess

verify_device swkeybd



export ORIG_FILE=scripts/retype/original.txt
export COPIED_FILE=scripts/retype/original.copy

verbose "retyping file $RECORDED_FILE"
rm -f $COPIED_FILE
verbose "  launching xterm/cat"
xterm -e 'cat > $COPIED_FILE' &
sleep 2
verbose "  launching xnee"
$XNEE --retype-file $ORIG_FILE 
sleep 5 
verbose "  faking control-d"
fake_controld
sleep 2
fake_controld
killall xnee

diff $ORIG_FILE $COPIED_FILE > /dev/null 2>/dev/null
RESULT=$?
verify_same "$RESULT" "0"     



sleep 5
STRING="hi, this is a test string"
export NEW_FILE1=/tmp/retype1.txt
export NEW_FILE2=/tmp/retype2.txt
echo $STRING > $NEW_FILE1
verbose "  launching xterm/cat"
xterm -e 'cat > $NEW_FILE2' &
sleep 2
verbose "  launching xnee"
echo $STRING | $XNEE --retype-file -
sleep 5 
verbose "  faking control-d"
fake_controld
sleep 2
diff $NEW_FILE1 $NEW_FILE2 > /dev/null 2>/dev/null
RESULT=$?
verify_same "$RESULT" "0"     




result_log $MYNAME 
fake_controlc
fake_controld
