/* $Id: configuration.h,v 1.2 1999/07/22 09:48:05 stano Exp $

   Configuration

  (C) 1999 Stanislav Meduna <stano@eunet.sk>
*/

#ifndef _CONFIGURATION_H_
#define _CONFIGURATION_H_

#include <config.h>

#include <xkbsel.h>

/* Configuration structure */
typedef struct
{
	char section[32];
	char entry[32];
	char qualif[32];
	int  nvalues;
	char *values[32];   /* must be freed */
} config_entry_t;

/* Configuration keywords */

#define SEC_SHORTCUT  "shortcut"
#define SEC_MAPSET    "mapset"

#define ENT_MAP       "map"

/* Print the actual configuration */
int print_config(void);

/* Check for xkbcomp bug and save result in xkb_comp_has_bug */
void check_xkbcomp_bug();

/* lex callback, called once for found entry
   The entry was allocated via malloc and should
   be freed by the caller.
*/
void config_entry_cb(config_entry_t *entry);

/* free the memory used by a config entry */
void free_config_entry(config_entry_t *entry);

/* Get a path name for a compiled map. Returned data
   was allocated via malloc and should be freed when
   no more needed.
*/
int get_compiled_map_names(const db_record_t *rec, char **user, char **sys);

#endif /* _CONFIGURATION_H_ */
