/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <errno.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_STDARG_H
#include <stdarg.h>
#elif HAVE_VARARGS_H
#include <varargs.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <glib.h>

#include <libxfce4util/util.h>

#include "glade_gui.h"
#include "glade_support.h"
#include "glade_callbacks.h"

#include "constants.h"
#include "types.h"

#include "run.h"
#include "reg.h"
#include "input.h"
#include "misc.h"
#include "entry.h"

/*#define DEBUG*/

static GList *run_list = NULL;

/* do this: start a long copy operation, while it is proceeding, press run button
 * and execute gkrellm. When the copy procedure finishes, xftree goes off into
 * full cpu usage. A backtrace reveals that it is cycling on a p_threads mutex.
 * (Bug in gthreads?). No mutexes are knowingly used, so maybe it would have been 
 * better to use posix threads... Who knows. For the meanwhile, disactivate use of
 * gthreads: */

#ifndef G_THREADS_IMPL_NONE
#define G_THREADS_IMPL_NONE
#endif

#ifndef G_THREADS_IMPL_NONE
static void *hilo_func(void *d)
{
    char *returnSTR = NULL;
    char **argv = (char **)d;
    /*printf("DBG:Thread here\n");
       {int i;for (i=0;argv[i]!=NULL;i++)printf("arg[%d]=%s\n",i,argv[i]);} */

    {
	int status, child;
	child = fork();
	if(child < 0)
	    g_assert_not_reached();

	if(!child)
	{
	    if(!fork())
	    {
		execvp(argv[0], argv);
		_exit(1);
	    }
	    _exit(1);
	}
	else
	    wait(&status);
    }

    return(returnSTR);
}
#endif

int runv(GtkTreeView * treeview, char *argv[])
{

#ifndef G_THREADS_IMPL_NONE
    gpointer thread_return = NULL;
    GThread *thread;
#endif
    gchar *fullpath;
    const char *fork_dir;
    

    fullpath=g_find_program_in_path(argv[0]);


    if(!fullpath || access(fullpath,X_OK)!=0)
    {
#ifdef DEBUG
	if(fullpath) printf("DBG:strlen(%s)=%d\n",fullpath,strlen(fullpath)); 
#endif
	/*if (strlen(fullpath))printf("DBG:access=%d\n",
	   access(fullpath,X_OK)); */
	print_status(treeview, "xf_ERROR_ICON", strerror(EACCES), " ", 
			argv[0], NULL);
	return FALSE;
    } else {
	    g_free(fullpath);
	    fullpath=NULL;
    }
    
    /*printf("DBG:workdir=%s\n",get_selected_chdir(treeview));*/
    fork_dir=get_selected_chdir(treeview);
    if (chdir(fork_dir) < 0){
	    print_diagnostics(treeview, "xf_ERROR_ICON", strerror(EACCES), " ", 
			fork_dir, NULL);
	    return FALSE;
    }

#ifndef G_THREADS_IMPL_NONE
    /* initialize the thread system */
    if (!g_thread_supported())
        g_thread_init(NULL);

    if ((thread = g_thread_create((GThreadFunc)hilo_func, (gpointer)argv,
                    TRUE, NULL)) != NULL) {
        thread_return = g_thread_join(thread);
    }
    else
#endif
    {
	    int status, child;
#ifdef DEBUG
	printf("DBG: running...");
	for (status=0;argv[status];status++)
		printf (" %s",argv[status]);
	printf("\n");
#endif
	    
        child = fork();
	if(child < 0)
	    g_assert_not_reached();
	if(!child)
	{
	    usleep(5000);
	    if(!fork())
	    {
	        usleep(5000);
#ifdef DEBUG
	printf("DBG: forked...");
	for (status=0;argv[status];status++)
		printf (" %s",argv[status]);
	printf("\n");
#endif
		/*fclose(stdin);*/
#ifdef DEBUG
		chdir(fork_dir);
		printf("DBG: chdir to %s\n",fork_dir);
#endif
		execvp(argv[0], argv);
		_exit(1);
	    }
    	    chdir("/");
	    _exit(1);
	}
	else {
    	    chdir("/");
	    wait(&status);
	}
    }
    return TRUE;

}

/* run without files associated (input)
   run with file associated: double click(input if !registered)
   openwith (menu): requires selection, can be multiple.
   */

int  parse_runline(char **argv,char *cmd_line,
		gchar **app, gchar **arg){
    char *p=NULL;
    int i=0;
    gboolean more_args,is_argv0=TRUE;
    /* remove leading and trailing whitespace */
#ifdef DEBUG
  printf("DBG4.1:command is =%s\n",(cmd_line)?cmd_line:"NULL");
#endif
    if (cmd_line && strlen(cmd_line)){
       p=g_strstrip(cmd_line);
       if (!strlen(p)) p=NULL;
    }
#ifdef DEBUG
  printf("DBG4.2:command is =%s\n",(cmd_line)?cmd_line:"NULL");
#endif

    if (*p) more_args=TRUE; else more_args=FALSE;
    while (more_args){
       char tok;
       if (*p=='\"'){  p++;  tok='\"';} else  tok=' ';
       for (argv[i]=p;*p && *p!=tok;p++);
       if (!*p) more_args=FALSE;
       else {
           *p=0;
	   for (p++;*p && *p == ' ';p++);
	   if (!*p) more_args=FALSE;
	   else more_args=TRUE;
       }
#ifdef DEBUG
	    printf("DBG: argv[%d]=%s\n",i,argv[i]);
#endif
       if (!strlen(argv[i]))continue;
       if (arg) {
         if (is_argv0){
	    is_argv0=FALSE;
 	    if(app != NULL) {
		if (tok==' ') *app=g_strdup(argv[i]);
		else *app=g_strconcat("\"",argv[i],"\"",NULL);
	    }
	    else {
	       if (tok==' ') *arg=g_strconcat("-e ",argv[i],NULL);
	       else *arg=g_strconcat("-e ","\"",argv[i],"\"",NULL);
	    }
         } else {
	       gchar *g;
	       if (!(*arg)) {
		  *arg=g_strdup("");
	          if (tok==' ') g=g_strconcat(*arg,argv[i],NULL);
		  else g=g_strconcat(*arg,"\"",argv[i],"\"",NULL);
	       } else {
	          if (tok==' ') g=g_strconcat(*arg," ",argv[i],NULL);
		  else	  g=g_strconcat(*arg," \"",argv[i],"\"",NULL);
	       }
	       g_free(*arg);
	       *arg=g;	
         }
       }
       if (i == MAX_ARGS-1){
	     argv[i]=NULL;
	     break;
      
       } 
       i++;
    }
    argv[i]=NULL;
#ifdef DEBUG
	    printf("DBG: app=%s arg=%s\n",(app)?*app:"NULL",(arg)?*arg:"NULL");
#endif
    return i;
			    
}

int on_run_path(GtkTreeView * treeview, char *in_cmd, char *path, gboolean in_terminal, gboolean remember, gboolean put_in_history)
{
    static gchar *gs=NULL;
    gchar *term=NULL;
/*    GList *ee = run_list;*/
    int i,j;
    char *argv[MAX_ARGS], *cmd_line=NULL;
    gchar *app=NULL, *arg=NULL;

#ifdef DEBUG
    printf("in_cmd=%s\n",in_cmd);
#endif

    i = 0;
    argv[0] = 0;
    if(in_terminal)
    {
	if (getenv("TERM") && strlen( getenv("TERM"))){
		gchar *c,*t=g_strdup(getenv("TERM"));
    		t=g_strstrip(t);
		if (strchr(t,' '))t=strtok(t," ");
		c=g_find_program_in_path(t);
		if (c && access(c,X_OK)==0) {
		  term = g_strdup(getenv("TERM"));
		  /*  parse it to argv */
		  if (strcmp(t,"xterm")==0){
			 if(getenv("XFFM_HOLD_XTERM") && strlen( getenv("XFFM_HOLD_XTERM")))
			   cmd_line=g_strconcat(term," -hold"," -e ",in_cmd,NULL);
			else
			   cmd_line=g_strconcat(term," -e ",in_cmd,NULL);
		  }
		  else 
		        cmd_line=g_strconcat(term," -e ",in_cmd,NULL);
		} else term = NULL;
		g_free(c);c=NULL;
		g_free(t);t=NULL;
	} 
		
	if(!term) {
	    /*term = g_strdup("xterm -j -s -sl 256");*/
	    term = g_strdup("xterm -sl 256");
	    if (getenv("XFFM_HOLD_XTERM") && 
			strlen( getenv("XFFM_HOLD_XTERM")))
		    cmd_line=g_strconcat(term," -hold"," -e ",in_cmd,NULL);
	    else 
		    cmd_line=g_strconcat(term," -e ",in_cmd,NULL);    
	}
    } else { /* not in terminal */
        cmd_line = g_strdup(in_cmd);
    }

#ifdef DEBUG
    printf("1 cmd_line=%s\n",cmd_line);
#endif
//    i=parse_runline(argv,cmd_line,(in_terminal)?NULL:&app,&arg);
    i=parse_runline(argv,cmd_line,&app,&arg);

    /* command argv done, only need to add the file path */
    if(path)
    {
	    for (j=1;argv[j];j++) {
		    if (strcmp(argv[j],"\%s")==0){
			    argv[j]=path;
			    break;
		    }
		    if (strstr(argv[j],"\%s")){
			    gs=g_strconcat(argv[j]," ",path,NULL);
			    g_snprintf(gs,strlen(gs),argv[j],path);
			    argv[j]=gs;
			    break;
		    }

	    }
	    if (!argv[j]) {
		    argv[i++]=path;
		    argv[i] = NULL;
	    }
    }

    
	    
    if(!runv(treeview, argv))
    {
        g_free(gs);gs=NULL;
	g_free(app);app=NULL;
	g_free(arg);arg=NULL;
	g_free(cmd_line);cmd_line=NULL;
	g_free(term);term=NULL;

	return FALSE;
    }

    if (put_in_history){
	static void save_run_path(char *p);
	save_run_path(in_cmd);
    }
    if(path && remember)
    {
	char *sfx;
	sfx = strchr(path, '.');
	if (sfx && strchr(sfx,'/')) {
		sfx=strrchr(sfx,'/');
		sfx=strchr(sfx,'.');
	}

	if(!sfx && strlen(path) > 1)
	{
	    sfx = strrchr(path, '/');
	    if(sfx) sfx++;
	}
	if(sfx)
	{
#ifdef DEBUG
	    printf("DBG: adding %s %s\n",app,arg); 
#endif
	    reg_add_suffix(sfx, app, arg);
	    reg_save();
	}
    }
    g_free(gs);gs=NULL;
    g_free(app);app=NULL;
    g_free(arg);arg=NULL;
    g_free(cmd_line);cmd_line=NULL;
    g_free(term);term=NULL;
    return TRUE;
}

int on_run(GtkTreeView * treeview, char *in_cmd, tree_entry_t * en, gboolean in_terminal, gboolean remember, gboolean put_in_history)
{
	char *path=NULL;
	if (en && !IS_APP_TYPE(en->type)) path=en->path;
	return on_run_path(treeview, in_cmd, path, in_terminal, remember, put_in_history);
}


static void save_run_path(char *p)
{				
    char fname[_POSIX_PATH_MAX];
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1,CURRENT_RUN_HISTORY,
		    G_DIR_SEPARATOR); 
    save_to_history(fname,p);
}


GList *set_run_combo(history_combo_info_t *combo_info)
{
    tree_details_t *tree_details = get_tree_details(combo_info->treeview);
    char *p;
    GtkWidget *w;
    GtkTreeIter iter;
    tree_entry_t *en;
    static char fname[_POSIX_PATH_MAX];
    /* eliminate pre 4.0-beta3 runlist, if any */
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, "xffm%cxffm.runlist",
		    G_DIR_SEPARATOR);
    unlink(fname);
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, "xffm%cxffm.runlist.dbh",
		    G_DIR_SEPARATOR);
    unlink(fname);
    xfce_get_userfile_r(fname, _POSIX_PATH_MAX-1, CURRENT_RUN_HISTORY,
		    G_DIR_SEPARATOR);
    if (access(fname,F_OK)!=0){
	    /* create a new list from reg information */
	    GList *l=reg_app_list();
	    GList *tmp;
#ifdef DEBUG
	    printf("DBG:creating history from reg list\n");
#endif
	    for (tmp=l;tmp;tmp=tmp->next) {
		    save_run_path((char *)tmp->data);
		    g_free((char *)tmp->data);
		    tmp->data=NULL;
	    }
	    g_list_free(l);
    }
    get_history_list(&run_list,fname,"");
    combo_info->active_dbh_file=fname;
    combo_info->list=run_list;

    if(!run_list) g_assert_not_reached();
    en = get_selected_entry(combo_info->treeview, &iter);
    if (en) {
	p = g_strdup(reg_app_by_file(en->path));
    	if (p) run_list = g_list_prepend(run_list, p);
    }
    set_limited_combo(combo_info,NULL);
    return run_list;
}

#if 0
void set_reg_combo(GtkTreeView * treeview)
{
    char *p;
    tree_details_t *tree_details = get_tree_details(treeview);
    GtkWidget *w;
    GtkTreeIter iter;
    tree_entry_t *en;
    en = get_selected_entry(treeview, &iter);

    w = lookup_widget(tree_details->window, "input_combo");
    reg_list = reg_app_list();

    p = g_strdup(reg_app_by_file(en->path));
    reg_list = g_list_prepend(reg_list, p);

    if(reg_list)
    {
	gtk_combo_set_popdown_strings(GTK_COMBO(w), reg_list);
	reg_list = reg_app_list_free(reg_list);
    }

}
#endif

void double_click_run(tree_details_t *tree_details,
		tree_entry_t *en){
    char *cmd;
    FILE *pipe;
    char *a=NULL;
    gboolean interm=FALSE;
    /* interm specified? */
    if (IS_IN_TERM(en->subtype)) interm=TRUE;
    else if (!IS_APP_TYPE(en->type)){
    /* is it a script? (not applicable to application stuff*/
     cmd = (char *)malloc(strlen("file \"xx\"") + strlen(en->path) + 1);
     if(!cmd) g_assert_not_reached();
     sprintf(cmd, "file \"%s\"", en->path);
     pipe = popen(cmd, "r");
     if(pipe)
     {
	char *p, line[1024];
	fgets(line, 1023, pipe);
	line[1023] = 0;
	pclose(pipe);
	if((p = strstr(line, ": ")) != NULL)
	{
	    p += 2;
	    if(strstr(p, "script")) interm=TRUE;
	}
     }
     g_free(cmd);
     cmd=NULL;
    }

    
     /* filter element is double used for arguments here */
    if (IS_APP_TYPE(en->type) && en->filter) a=g_strconcat(en->path," ",en->filter,NULL);
    else if (IS_APP_TYPE(en->type) || IS_EXE(en->type)) a=g_strdup(en->path);
    else return;
   
    print_status(tree_details->treeview, "xf_INFO_ICON",
		   _("Executing"), " : ", 
		    FILENAME(en), 
		   NULL);
    on_run(tree_details->treeview, a, en, interm, FALSE,FALSE);
    g_free(a);a=NULL;
    return;
}

void double_click_open_with(tree_details_t *tree_details,
		tree_entry_t *en){
    /* open with */
    char *name;
    char arguments[256];
    reg_t *prg;
    name = strrchr(en->path, '/');
    if(!name) g_assert_not_reached();
    if(strlen(name) > 1) name++;
     /*printf("DBG:looking for %s\n",name); */
    prg = reg_prog_by_file(name);
    if(prg)
    {
	sprintf(arguments, "%s %s", prg->app, (prg->arg) ? prg->arg : " ");
	if(on_run(tree_details->treeview, arguments, en, FALSE, FALSE, FALSE))
	{
	    print_status(tree_details->treeview, "xf_INFO_ICON", 
			    arguments, 
			    NULL);
	}
	else
	{
	    print_status(tree_details->treeview, "xf_ERROR_ICON", 
			    strerror(EINVAL), arguments, 
			    NULL);
	}
	/*printf("DBG:%s %s\n",arguments,en->path); */
    }
    else
    {		/*if !registered, run directly */
	/*printf("DBG:regnot found: %s\n",en->path); */
	show_input(tree_details->treeview, RUN_DOUBLE_CLICK);
	print_status(tree_details->treeview, "xf_QUESTION_ICON", 
			_("Input requested"),NULL);
	/*if(IS_BOOKMARK_TYPE(en->type) && IS_DIR(en->type))
	{
	    GtkEntry *entry;
	    entry = (GtkEntry *) 
		    lookup_widget(tree_details->window, "input_entry");
	    gtk_entry_set_text(entry, "xffm");
		
	}*/
	    
    }
    return;
}



/* callbacks */
void tb_run(GtkButton * button, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) button);

/*   GtkWidget *w;
   w=lookup_widget(widget,"input_combo");
   if (run_list) gtk_combo_set_popdown_strings (GTK_COMBO (w),run_list);*/
    show_input(treeview, RUN_INPUT);
}

void on_open_with_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    tree_entry_t *en;
    GtkTreeIter iter;
    en = get_selected_entry(treeview, &iter);
    if(!en)
	show_input(treeview, RUN_INPUT);
    else
    {
	show_input(treeview, RUN_DOUBLE_CLICK);
	print_status(treeview, "xf_QUESTION_ICON", _("Input requested"), NULL);
    }


}

void on_run_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkTreeView *treeview = get_treeview((GtkWidget *) menuitem);
    show_input(treeview, RUN_INPUT);

}
