/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <errno.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <glib.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include <libxfce4util/util.h>

#include <libxml/parser.h>
#include <libxml/tree.h>


#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "add_node_contents.h"
#include "entry.h"
#include "gdir.h"
#include "misc.h"
#include "refresh.h"
#include "tubo.h"



static gdir_t apps_gdir;
static gdir_t **apps_popup_gdir;
static gboolean *valid_app;

static int app_count;

static void set_icon_type(int it,tree_entry_t *en,char *custom_icon){
  switch (it){
     case -1: if (custom_icon) {
		      en->tag = g_strdup(custom_icon);
		      SET_CUSTOM_ICON(en->subtype);
	      }
	      else  en->tag = g_strdup("xf_AGEN_ICON");
	      break;
     default: en->tag = g_strdup("xf_AGEN_ICON");break;
     case 0: en->tag = g_strdup("xf_ADEMO_ICON");break;
     case 1: en->tag = g_strdup("xf_APENPD_ICON");break;
     case 2: en->tag = g_strdup("xf_AFILE_ICON");break;
     case 3: en->tag = g_strdup("xf_AAPPS_ICON");break;
     case 4: en->tag = g_strdup("xf_AGAMES_ICON");break;
     case 5: en->tag = g_strdup("xf_AMAN_ICON");break;
     case 6: en->tag = g_strdup("xf_AMULTIMEDIA_ICON");break;
     case 7: en->tag = g_strdup("xf_ANETWORK_ICON");break;
     case 8: en->tag = g_strdup("xf_ACOLOR_ICON");break;
     case 9: en->tag = g_strdup("xf_APRINT_ICON");break;
     case 10: en->tag = g_strdup("xf_ASCHEDULE_ICON");break;
     case 11: en->tag = g_strdup("xf_ASOUND_ICON");break;
     case 12: en->tag = g_strdup("xf_ASYS_ICON");break;
     case 13: en->tag = g_strdup("xf_AMAIL_ICON");break;
  }
  return;
}

static gboolean add_appfolder(dir_t *gl,
		char *caption,
		char *app,int it,
		tree_entry_t *en,
		char *in_term,
		char *custom_icon){
   gchar *temp_name = NULL;
   gchar *space = NULL;
   gchar *abs_path = NULL;
   gchar *args = NULL;
   
   if (!app) 
   {
       return FALSE;
   }
   temp_name = g_strdup(app);
   space = strstr(temp_name, " ");
   /* This half broken, 
    * what if it's an absolute path with a space in the middle ?
    * what if it's a path with an argument(s)?
    * The latter should be preffered. */
   if (space)
   {
       *space++ = '\0';
       if (strlen(space)) 
       {
           args=space;
       }
   }
   abs_path = g_find_program_in_path(temp_name);
   if (abs_path == NULL)
   {
	   g_free(temp_name);
	   temp_name=NULL;
	   return FALSE;
   }

   gl->en = stat_entry(abs_path, en->type);
   if(caption){
	   gl->pathv = g_strdup(caption);
   } else {
	   gl->pathv = g_path_get_basename(abs_path);
   }
   if (args) {
	   g_free(gl->en->filter);
	   gl->en->filter = g_strdup(args);
   }
   if (in_term && atoi(in_term)) SET_IN_TERM(gl->en->subtype);
   set_icon_type(it,gl->en,custom_icon);
   g_free(temp_name);
   temp_name=NULL;
   return 1;
}

static gboolean app_found(const gchar *app)
{
   gchar *temp_name = NULL;
   gchar *space = NULL;
   gchar *abs_path = NULL;
   
   if (!app) 
   {
       return FALSE;
   }
   temp_name = g_strdup(app);
   space = strstr(temp_name, " ");
   /* This half broken, 
    * what if it's an absolute path with a space in the middle ?
    * what if it's a path with an argument(s)?
    * The latter should be preffered. */
   if (space)
   {
       *space = '\0';
   }
   abs_path = g_find_program_in_path(temp_name);
   if (abs_path == NULL)
   {
	   g_free(temp_name);
	   temp_name=NULL;
	   return FALSE;
   }

   g_free(temp_name);temp_name=NULL;
   g_free(abs_path);abs_path=NULL;

   return TRUE;
}

static int count_appfolder(char *app){
	if (valid_app) {
	   if (!app) {
		   valid_app[app_count]=FALSE;
		   return 0;
	   }
	   valid_app[app_count] = app_found(app);
	}
	return 1;
}


static char *recursive_fun(GtkTreeView *treeview,
		xmlDocPtr doc,xmlNodePtr node,
		char *keyword,
		gboolean count,
		tree_entry_t *en);

/* main_recurse searches for single keyword */
static char * main_recursive_fun(GtkTreeView *treeview,
		xmlDocPtr doc,xmlNodePtr root,
		char *keyword,
		gboolean count,
		tree_entry_t *en){
    xmlNodePtr node;
    if (!root) g_assert_not_reached();
    if (!root->children) return NULL;
    for(node = root->children; node; node = node->next){
	/*printf("DBG:child=%s\n",node->name); */
	if (xmlStrEqual((const xmlChar *)"Groups", node->name)){
	    /* main elements here: Group */	
	    /*printf("DBG:* %s\n",keyword); */
	    return main_recursive_fun(treeview,doc,node,"Group",count,en);
	}
	if (xmlStrEqual((const xmlChar *)"Group", node->name)){
	    /* main elements here: Popup Control */	
	    /*printf("DBG:** %s\n",keyword); */
	    recursive_fun(treeview,doc,node,"Group",count,en);
	}
 	if (xmlStrEqual((const xmlChar *)"Mailcheck command", (const xmlChar *)keyword)){
	  /*printf("DBG:** %s\n",keyword); */
	  return main_recursive_fun(treeview,doc,node,"Command",count,en);
	  /*if (xmlStrEqual((const xmlChar *)"Command", node->name)){
	    char *e=xmlNodeListGetString(doc, node->children, 1);	
	    return e;
	  }*/
	}
 	if (xmlStrEqual((const xmlChar *)"Mailcheck term", (const xmlChar *)keyword)){
	  /*printf("DBG:** %s\n",keyword); */
	  return main_recursive_fun(treeview,doc,node,"Command term",count,en);
	  /*if (xmlStrEqual((const xmlChar *)"Command", node->name)){
	    char *e=(char *)xmlGetProp(node, (const xmlChar *)"term");	    
	    return e;
	  }*/
	}
	if (xmlStrEqual((const xmlChar *)"Item", node->name)){
	    /* main elements here: Caption Command Tooltip Icon */	
	    /*printf("DBG:**** %s\n",keyword); */
	    recursive_fun(treeview,doc,node,"Item",count,en);
	}
 	if (xmlStrEqual((const xmlChar *)"Command", (const xmlChar *)keyword)){
	  if (xmlStrEqual((const xmlChar *)"Command", node->name)){
	    /* main elements here: Caption Command Tooltip Icon */	
	    char *e=xmlNodeListGetString(doc, node->children, 1);	
	    /*printf("DBG:**** %s %s\n",keyword,e); */
	    return g_strdup(e);
	  }
	}
 	if (xmlStrEqual((const xmlChar *)"Tooltip", (const xmlChar *)keyword)){
	  if (xmlStrEqual((const xmlChar *)"Tooltip", node->name)){
	    /* main elements here: Caption Command Tooltip Icon */	
	    char *e=xmlNodeListGetString(doc, node->children, 1);	
	    /*printf("DBG:**** %s %s\n",keyword,e); */
	    return g_strdup(e);
	  }
	}
  	if (xmlStrEqual((const xmlChar *)"Caption", (const xmlChar *)keyword)){
	  if (xmlStrEqual((const xmlChar *)"Caption", node->name)){
	    /* main elements here: Caption Command Tooltip Icon */	
	    char *e=xmlNodeListGetString(doc, node->children, 1);	
	    /*printf("DBG:**** %s %s\n",keyword,e); */
	    return g_strdup(e);
	  }
	}	
	if (xmlStrEqual((const xmlChar *)"Command term", (const xmlChar *)keyword)){
	  if (xmlStrEqual((const xmlChar *)"Command", node->name)){
	    /* main elements here: Caption Command Tooltip Icon */	
	    char *e=(char *)xmlGetProp(node, (const xmlChar *)"term");	    
	    /*printf("DBG:**** %s term=%s\n",keyword,e); */
	    return e;
	  }
	}
 	if (xmlStrEqual((const xmlChar *)"Icon id", (const xmlChar *)keyword)){
	  if (xmlStrEqual((const xmlChar *)"Icon", node->name)){
    	    xmlChar *value = xmlGetProp(node, (const xmlChar *)"id");
	    /*printf("DBG:**** %s %s\n",keyword,value); */
	    return (char *)value;
	  }
	}
 	if (xmlStrEqual((const xmlChar *)"Icon", (const xmlChar *)keyword)){
	  if (xmlStrEqual((const xmlChar *)"Icon", node->name)){
    	    char *e=xmlNodeListGetString(doc, node->children, 1);
	    /*printf("DBG:**** %s %s \n",keyword,e); */
	    return (char *)g_strdup(e);
	  }
	}
   }
    return NULL;
}

/* recurse searches for a set of keywords */
char *recursive_fun(GtkTreeView *treeview,
		xmlDocPtr doc,xmlNodePtr node,
		char *keyword,
		gboolean count,
		tree_entry_t *en
		){
   for(node = node->children; node; node = node->next)
    {
      char *lt=NULL,*ct=NULL,*cterm=NULL,*it=NULL,*itid=NULL;
      if(xmlStrEqual((const xmlChar *)keyword, (const xmlChar *)"Group")){
	if(xmlStrEqual(node->name, (const xmlChar *)"Control")){
           /*printf("DBG:+++ %s \n",node->name); */
	   lt=main_recursive_fun(treeview,doc,node,
			   "Tooltip",count,en);
	   ct=main_recursive_fun(treeview,doc,node,
			   "Mailcheck command",count,en);
	   if (ct){
	       cterm=main_recursive_fun(treeview,doc,node,
			       "Mailcheck term",count,en);
	       /*printf("DBG: Mailcheck -> %s icon=%s interm=%s custom_icon=%s\n",
			   ct,itid,cterm,it);*/
	       itid=g_strdup("13");
	       it=NULL;
	   }
	   else 
	   {
	     ct=main_recursive_fun(treeview,doc,node,
			     "Command",count,en);
	     cterm=main_recursive_fun(treeview,doc,node,
			     "Command term",count,en);
	     it=main_recursive_fun(treeview,doc,node,
			     "Icon",count,en);
	     itid=main_recursive_fun(treeview,doc,node,
			     "Icon id",count,en);
	     /*printf("DBG: Control -> %s icon=%s interm=%s custom_icon=%s\n",
			   ct,itid,cterm,it);*/
	     
	   }
	   if (!count && valid_app && valid_app[app_count]){ 
		   add_appfolder(&(apps_gdir.gl[apps_gdir.pathc]),
				   lt,
				   ct, atoi(itid),en,cterm,it);
		   apps_gdir.pathc++;
	   }
	   
	   else if (count && valid_app) {
		   if (!count_appfolder(ct))
			if (ct) print_diagnostics(treeview,"xf_WARNING_ICON",
				   strerror(ENOENT),": ",ct,"\n",NULL);
	   }	   
	   app_count++;
	}
	if(xmlStrEqual(node->name, (const xmlChar *)"Popup")){
           /*printf("DBG:+++ %s\n",node->name); */
	   recursive_fun(treeview,doc,node,"Item",count,en);
	}
      }
      if(xmlStrEqual((const xmlChar *)keyword, (const xmlChar *)"Item")){
	 if (apps_popup_gdir) {
	/*printf("DBG:+++++ Item:%s\n",node->name);*/
	   lt=main_recursive_fun(treeview,doc,node,"Caption",count,en);
	   ct=main_recursive_fun(treeview,doc,node,"Command",count,en);
	   if (ct) {
	     cterm=main_recursive_fun(treeview,doc,node,"Command term",count,en);
	     it=main_recursive_fun(treeview,doc,node,"Icon",count,en);
	     itid=main_recursive_fun(treeview,doc,node,"Icon id",count,en);
	     if (valid_app && valid_app[app_count]) {
    	             /*printf("DBG: +++app_count=%d, apps_popup_gdir[i]->pathc=%d\n",
		    	app_count,apps_popup_gdir[app_count]->pathc);*/
		     if (!count) 
		     {
		         add_appfolder(&(apps_popup_gdir[app_count]->
						 gl[apps_popup_gdir[app_count]->pathc]),
				     lt,
				     ct,
     				     atoi(itid),
				     en,
				     cterm,
				     it);
	             }
				     
	     } 
	     if (app_found(ct)) apps_popup_gdir[app_count]->pathc++;
	     else if (!count) {
		   print_diagnostics(treeview,"xf_WARNING_ICON",
				   strerror(ENOENT),": ",ct,"\n",NULL);
	     }
	     /*printf("DBG: Item-> %s icon=%s interm=%s custom_icon=%s\n",
			   ct,itid,cterm,it);*/
	   }
	 }
      }
#if 0
      /* seems this section is a left over.... */
       if(xmlStrEqual((const xmlChar *)keyword, (const xmlChar *)"Mailcheck")){
	/*printf("DBG:+++++ Mailcheck:%s\n",node->name);*/
	if(xmlStrEqual(node->name, (const xmlChar *)"Command")){
	}
      }
#endif
      g_free(ct);ct=NULL;
      g_free(cterm);cterm=NULL;
      g_free(it);it=NULL;
      g_free(itid);itid=NULL;
   }
	
    return NULL;

}

int open_apps(GtkTreeView * treeview, 
		GtkTreeIter * iter, 
		GtkTreePath * treepath, 
		gpointer user_data){
    char rcfile[_POSIX_PATH_MAX];
    xmlNodePtr root;
    int i;
    char *c=NULL;
    xmlDocPtr doc = NULL;
    tree_entry_t *en = get_entry(treeview, iter);
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);

    xfce_get_userfile_r(rcfile, _POSIX_PATH_MAX-1, "xfce4rc");
    rcfile[_POSIX_PATH_MAX-1]=0;
    xmlKeepBlanksDefault(0);

    doc = xmlParseFile(rcfile);
    if (!doc) return 0;
    root = xmlDocGetRootElement(doc);
    if(!root || !xmlStrEqual(root->name, (const xmlChar *)"Xfce")) {
	xmlFreeDoc(doc);
	return 0;
    }
    

    if(!root)return 0;

    /* first lets count number of panel elements */
    apps_popup_gdir=NULL;
    valid_app=NULL;
    
    app_count=0;
    apps_gdir.pathc=0;
    c=main_recursive_fun(treeview,doc,root,"Groups",TRUE,en); 
    g_free(c); c=NULL;  
    /*printf("DBG: 1#######app_count=%d, pathc=%d\n",app_count,apps_gdir.pathc);*/
    
    /* assign memory */
    valid_app=(gboolean *)malloc(app_count*sizeof(gboolean));
    apps_gdir.gl = (dir_t *) malloc(app_count * sizeof(dir_t));
    apps_popup_gdir = (gdir_t **) malloc(app_count * sizeof(gdir_t *));   
    for (i=0;i<app_count;i++) {
	    apps_popup_gdir[i] = (gdir_t *) malloc(sizeof(gdir_t));
	    apps_popup_gdir[i]->pathc=0;	    
	    apps_popup_gdir[i]->gl=NULL;	    
    }

    /* lets count again, this time popup elements per panel button 
     * and valid panel buttons*/
    app_count=0;
    apps_gdir.pathc=0;
    c=main_recursive_fun(treeview,doc,root,"Groups",TRUE,en);
    g_free(c);c=NULL;
    /*printf("DBG: 2#######app_count=%d, pathc=%d\n",app_count,apps_gdir.pathc);
      printf("DBG:validapps=");for (i=0;i<app_count;i++) printf(" %d ",valid_app[i]);
     printf("\n");
     */
    for (i=0;i<app_count;i++){
    	   /*printf("DBG: ###app_count=%d, apps_popup_gdir[i]->pathc=%d\n",
		    i,apps_popup_gdir[i]->pathc);*/
	   if (apps_popup_gdir[i]->pathc) {
		   apps_popup_gdir[i]->gl = (dir_t *) 
			   malloc(apps_popup_gdir[i]->pathc * sizeof(dir_t));
		   apps_popup_gdir[i]->gl->pathv= NULL;
		   apps_popup_gdir[i]->pathc=0; /* initialize for reuse */
	   } 
    }
     /* all memory in place, read values */
    app_count=0;
    apps_gdir.pathc=0;
    c=main_recursive_fun(treeview,doc,root,"Groups",FALSE,en);
    g_free(c);c=NULL;
  
    /*printf("DBG: 3#######app_count=%d, pathc=%d\n",app_count,apps_gdir.pathc);*/

    /* add main buttons */
    {
      int j=0;
      add_node_contents(treeview, iter, &apps_gdir);
        /* add drawers */
      for (i=0;i<app_count;i++){
        GtkTreeIter child;
        if (!valid_app || !valid_app[i]) continue;
        if (gtk_tree_model_iter_nth_child (treemodel,&child,iter,j)){
         if (apps_popup_gdir[i]->pathc)
		 add_node_contents(treeview, &child, apps_popup_gdir[i]);      
        }
        j++;
      }
    }
    
    /* free memory (if any) */
    
    for (i=0;i<apps_gdir.pathc;i++){
	   /* gdirfree(apps_popup_gdir[i]); will not work here! */
	   if (apps_popup_gdir[i]->gl) {
	       g_free(apps_popup_gdir[i]->gl->pathv);
	       apps_popup_gdir[i]->gl->pathv=NULL;
	       g_free(apps_popup_gdir[i]->gl);	  
	       apps_popup_gdir[i]->gl=NULL;     
	     }
	   g_free(apps_popup_gdir[i]);
	   apps_popup_gdir[i]=NULL;
    }
    g_free(apps_popup_gdir);
    apps_popup_gdir=NULL;
    gdirfree(&apps_gdir);
    g_free(valid_app);
    valid_app=NULL;
    
    xmlFreeDoc(doc);
        return(app_count);

	
}

