/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "inputcontrol.h"
#include "ConfigFile.H"
#include "main.h"
#include <wx/config.h>
#include <wx/settings.h>

BEGIN_EVENT_TABLE(TtInputControl, wxTextCtrl)
  EVT_KEY_DOWN(TtInputControl::onKeyDown)
  EVT_CHAR(TtInputControl::onChar)
  EVT_MOUSE_EVENTS(TtInputControl::onMouse)
END_EVENT_TABLE()

TtInputControl::TtInputControl (wxWindow* parent)
  : wxTextCtrl(parent, 2, _T(""), wxDefaultPosition, wxDefaultSize,
	           wxNO_BORDER|wxTE_MULTILINE|wxTE_READONLY|wxTE_RICH2|wxTE_PROCESS_TAB)
{
  //black text color
  this->textcolor = new wxColor(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWTEXT));
  //white background color
  this->bgcolor = new wxColor(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOW));
  this->localfont = NULL;
  wxFont f = TtConfigFile::getPtr()->getMainWindowFont();
  setFont(f);
}

TtInputControl::~TtInputControl () {
}

void TtInputControl::onKeyDown (wxKeyEvent& event) {
  if (event.AltDown()) {
    event.Skip();
    return;
  }

  if (!IsEditable()) {
    return;
  }

  Hauptfenster* haupt = Hauptfenster::getPtr();
  this->lesson = haupt->getLessonController()->getLesson();
  int keycode = event.GetKeyCode();
  switch (keycode) {
  case WXK_LEFT:
  case WXK_DOWN:
  case WXK_RIGHT:
  case WXK_UP:
  case WXK_HOME:
  case WXK_END:
  case WXK_DELETE:
  case WXK_INSERT:
  case WXK_PRIOR:
  case WXK_NEXT:
    /* Here are keys that are definitely wrong
     * but shall not increase the wrong key counter
     */
    haupt->SetStatusText(wxString(_("Wrong"))
			 + wxString(_T(' '))
			 + wxString(_("(excluded from false counter)")));
    if (TtConfigFile::getPtr()->getBellStatus()) {
      wxBell();
    }
    //don't skip
    break;
  case WXK_BACK:
    this->lesson->checkInput(keycode); //never true so far
    //don't skip
    break;
  case WXK_RETURN:
    //do it here instead of skip (else broken behaviour on Win32 with wxTE_RICH2)
    this->lesson->checkInput('\n');
    break;
  default:
    event.Skip(); // will result in a wxEVT_CHAR
    break;
  } 
}

void TtInputControl::onChar (wxKeyEvent& event) {
  if (event.AltDown()) {
    event.Skip();
    return;
  }
  int keycode = event.GetKeyCode();
  this->lesson->checkInput(keycode);
}

void TtInputControl::appendChar (wxUChar c) {
  if (c == wxUChar(_T('\n')) &&
      this->specialLineEnd != 0) {
    *this << (wxChar)this->specialLineEnd;
  }
  *this << (wxChar)c;
}

/* On Mouse action, ignore all specialties but give focus
 * I found an error (maybe on with KDE3) where MOUSE_DCLICK
 * is not catched.
 */
void TtInputControl::onMouse (wxMouseEvent& event) {
  SetFocus();
}

void TtInputControl::updateLook () {
  wxTextAttr attribs(*(this->textcolor),
		     *(this->bgcolor),
		     *(this->localfont));
  SetDefaultStyle(attribs);
  //this has problems because all marking of wrong inputs
  //would be deleted by this: not good
//   SetStyle(0,GetLastPosition(),attribs);
}

#include "commonElements.H"

void TtInputControl::setFont (wxFont& newFont) {
  this->specialLineEnd=common::specialLineEnd(newFont.GetEncoding());
  if (this->localfont != NULL) {
    delete this->localfont;
  }
  this->localfont = new wxFont(newFont);
  updateLook();
  SetFocus();
}

void TtInputControl::Clear() {
  Freeze();
  wxTextCtrl::Clear();
  Thaw();
}
