/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KURSBEGINWIZARD_H
#define KURSBEGINWIZARD_H

#include "ConfigFile.H"
#include <wx/wx.h>
#include <wx/wizard.h>

class KursWaehlenSeite : public wxWizardPageSimple {
public:
  KursWaehlenSeite (wxWizard *parent);
  ~KursWaehlenSeite ();

  void OnPageChanging (wxWizardEvent& e);
  void OnPageEnter (wxWizardEvent& e);

  inline int GetSelection() { return this->selection; };

private:
  wxArrayString ar;
  wxRadioBox* box;
  int selection;

  DECLARE_EVENT_TABLE()
};

class NameEingebenSeite : public wxWizardPageSimple {
public:
  NameEingebenSeite(wxWizard *parent);
  ~NameEingebenSeite ();

  void OnPageChanging (wxWizardEvent& e);
  void OnPageEnter (wxWizardEvent& e);

  inline wxString GetName () { return this->name; };

private:
  wxString name;
  wxStaticText* text;
  wxTextCtrl* tctrl;

  DECLARE_EVENT_TABLE()
};


class KursBeginWizard : public wxWizard {
public:
  KursBeginWizard (wxWindow* parent);
  ~KursBeginWizard ();

  bool runWizard ();
  int getKursNummer ();
  wxString getName ();

private:
  KursWaehlenSeite* p1;
  NameEingebenSeite* p2;
  wxWizardPageSimple* p3;
  wxStaticText* p3text;
};

#endif
