#include <stdlib.h>
#include <string.h>
#include "tom.h"

typedef struct {
    char *name;
    int value;
} GLConst;

static GLConst GLCONSTS[] = {
    {"GL_FALSE", GL_FALSE},
    {"GL_TRUE", GL_TRUE},
    /* Data types */
    {"GL_BYTE", GL_BYTE},
    {"GL_UNSIGNED_BYTE", GL_UNSIGNED_BYTE},
    {"GL_SHORT", GL_SHORT},
    {"GL_UNSIGNED_SHORT", GL_UNSIGNED_SHORT},
    {"GL_INT", GL_INT},
    {"GL_UNSIGNED_INT", GL_UNSIGNED_INT},
    {"GL_FLOAT", GL_FLOAT},
    {"GL_DOUBLE", GL_DOUBLE},
    {"GL_2_BYTES", GL_2_BYTES},
    {"GL_3_BYTES", GL_3_BYTES},
    {"GL_4_BYTES", GL_4_BYTES},
    /* Primitives */
    {"GL_LINES", GL_LINES},
    {"GL_POINTS", GL_POINTS},
    {"GL_LINE_STRIP", GL_LINE_STRIP},
    {"GL_LINE_LOOP", GL_LINE_LOOP},
    {"GL_TRIANGLES", GL_TRIANGLES},
    {"GL_TRIANGLE_STRIP", GL_TRIANGLE_STRIP},
    {"GL_TRIANGLE_FAN", GL_TRIANGLE_FAN},
    {"GL_QUADS", GL_QUADS},
    {"GL_QUAD_STRIP", GL_QUAD_STRIP},
    {"GL_POLYGON", GL_POLYGON},
    {"GL_EDGE_FLAG", GL_EDGE_FLAG},
    /* Vertex Arrays */
    {"GL_VERTEX_ARRAY", GL_VERTEX_ARRAY},
    {"GL_NORMAL_ARRAY", GL_NORMAL_ARRAY},
    {"GL_COLOR_ARRAY", GL_COLOR_ARRAY},
    {"GL_INDEX_ARRAY", GL_INDEX_ARRAY},
    {"GL_TEXTURE_COORD_ARRAY", GL_TEXTURE_COORD_ARRAY},
    {"GL_EDGE_FLAG_ARRAY", GL_EDGE_FLAG_ARRAY},
    {"GL_VERTEX_ARRAY_SIZE", GL_VERTEX_ARRAY_SIZE},
    {"GL_VERTEX_ARRAY_TYPE", GL_VERTEX_ARRAY_TYPE},
    {"GL_VERTEX_ARRAY_STRIDE", GL_VERTEX_ARRAY_STRIDE},
    {"GL_NORMAL_ARRAY_TYPE", GL_NORMAL_ARRAY_TYPE},
    {"GL_NORMAL_ARRAY_STRIDE", GL_NORMAL_ARRAY_STRIDE},
    {"GL_COLOR_ARRAY_SIZE", GL_COLOR_ARRAY_SIZE},
    {"GL_COLOR_ARRAY_TYPE", GL_COLOR_ARRAY_TYPE},
    {"GL_COLOR_ARRAY_STRIDE", GL_COLOR_ARRAY_STRIDE},
    {"GL_INDEX_ARRAY_TYPE", GL_INDEX_ARRAY_TYPE},
    {"GL_INDEX_ARRAY_STRIDE", GL_INDEX_ARRAY_STRIDE},
    {"GL_TEXTURE_COORD_ARRAY_SIZE", GL_TEXTURE_COORD_ARRAY_SIZE},
    {"GL_TEXTURE_COORD_ARRAY_TYPE", GL_TEXTURE_COORD_ARRAY_TYPE},
    {"GL_TEXTURE_COORD_ARRAY_STRIDE", GL_TEXTURE_COORD_ARRAY_STRIDE},
    {"GL_EDGE_FLAG_ARRAY_STRIDE", GL_EDGE_FLAG_ARRAY_STRIDE},
    {"GL_VERTEX_ARRAY_POINTER", GL_VERTEX_ARRAY_POINTER},
    {"GL_NORMAL_ARRAY_POINTER", GL_NORMAL_ARRAY_POINTER},
    {"GL_COLOR_ARRAY_POINTER", GL_COLOR_ARRAY_POINTER},
    {"GL_INDEX_ARRAY_POINTER", GL_INDEX_ARRAY_POINTER},
    {"GL_TEXTURE_COORD_ARRAY_POINTER", GL_TEXTURE_COORD_ARRAY_POINTER},
    {"GL_EDGE_FLAG_ARRAY_POINTER", GL_EDGE_FLAG_ARRAY_POINTER},
    {"GL_V2F", GL_V2F},
    {"GL_V3F", GL_V3F},
    {"GL_C4UB_V2F", GL_C4UB_V2F},
    {"GL_C4UB_V3F", GL_C4UB_V3F},
    {"GL_C3F_V3F", GL_C3F_V3F},
    {"GL_N3F_V3F", GL_N3F_V3F},
    {"GL_C4F_N3F_V3F", GL_C4F_N3F_V3F},
    {"GL_T2F_V3F", GL_T2F_V3F},
    {"GL_T4F_V4F", GL_T4F_V4F},
    {"GL_T2F_C4UB_V3F", GL_T2F_C4UB_V3F},
    {"GL_T2F_C3F_V3F", GL_T2F_C3F_V3F},
    {"GL_T2F_N3F_V3F", GL_T2F_N3F_V3F},
    {"GL_T2F_C4F_N3F_V3F", GL_T2F_C4F_N3F_V3F},
    {"GL_T4F_C4F_N3F_V4F", GL_T4F_C4F_N3F_V4F},
    /* Matrix Mode */
    {"GL_MATRIX_MODE", GL_MATRIX_MODE},
    {"GL_MODELVIEW", GL_MODELVIEW},
    {"GL_PROJECTION", GL_PROJECTION},
    {"GL_TEXTURE", GL_TEXTURE},
    /* Points */
    {"GL_POINT_SMOOTH", GL_POINT_SMOOTH},
    {"GL_POINT_SIZE", GL_POINT_SIZE},
    {"GL_POINT_SIZE_GRANULARITY", GL_POINT_SIZE_GRANULARITY},
    {"GL_POINT_SIZE_RANGE", GL_POINT_SIZE_RANGE},
    /* Lines */
    {"GL_LINE_SMOOTH", GL_LINE_SMOOTH},
    {"GL_LINE_STIPPLE", GL_LINE_STIPPLE},
    {"GL_LINE_STIPPLE_PATTERN", GL_LINE_STIPPLE_PATTERN},
    {"GL_LINE_STIPPLE_REPEAT", GL_LINE_STIPPLE_REPEAT},
    {"GL_LINE_WIDTH", GL_LINE_WIDTH},
    {"GL_LINE_WIDTH_GRANULARITY", GL_LINE_WIDTH_GRANULARITY},
    {"GL_LINE_WIDTH_RANGE", GL_LINE_WIDTH_RANGE},
    /* Polygons */
    {"GL_POINT", GL_POINT},
    {"GL_LINE", GL_LINE},
    {"GL_FILL", GL_FILL},
    {"GL_CCW", GL_CCW},
    {"GL_CW", GL_CW},
    {"GL_FRONT", GL_FRONT},
    {"GL_BACK", GL_BACK},
    {"GL_CULL_FACE", GL_CULL_FACE},
    {"GL_CULL_FACE_MODE", GL_CULL_FACE_MODE},
    {"GL_POLYGON_SMOOTH", GL_POLYGON_SMOOTH},
    {"GL_POLYGON_STIPPLE", GL_POLYGON_STIPPLE},
    {"GL_FRONT_FACE", GL_FRONT_FACE},
    {"GL_POLYGON_MODE", GL_POLYGON_MODE},
    {"GL_POLYGON_OFFSET_FACTOR", GL_POLYGON_OFFSET_FACTOR},
    {"GL_POLYGON_OFFSET_UNITS", GL_POLYGON_OFFSET_UNITS},
    {"GL_POLYGON_OFFSET_POINT", GL_POLYGON_OFFSET_POINT},
    {"GL_POLYGON_OFFSET_LINE", GL_POLYGON_OFFSET_LINE},
    {"GL_POLYGON_OFFSET_FILL", GL_POLYGON_OFFSET_FILL},
    /* Display Lists */
    {"GL_COMPILE", GL_COMPILE},
    {"GL_COMPILE_AND_EXECUTE", GL_COMPILE_AND_EXECUTE},
    {"GL_LIST_BASE", GL_LIST_BASE},
    {"GL_LIST_INDEX", GL_LIST_INDEX},
    {"GL_LIST_MODE", GL_LIST_MODE},
    /* Depth buffer */
    {"GL_NEVER", GL_NEVER},
    {"GL_LESS", GL_LESS},
    {"GL_GEQUAL", GL_GEQUAL},
    {"GL_LEQUAL", GL_LEQUAL},
    {"GL_GREATER", GL_GREATER},
    {"GL_NOTEQUAL", GL_NOTEQUAL},
    {"GL_EQUAL", GL_EQUAL},
    {"GL_ALWAYS", GL_ALWAYS},
    {"GL_DEPTH_TEST", GL_DEPTH_TEST},
    {"GL_DEPTH_BITS", GL_DEPTH_BITS},
    {"GL_DEPTH_CLEAR_VALUE", GL_DEPTH_CLEAR_VALUE},
    {"GL_DEPTH_FUNC", GL_DEPTH_FUNC},
    {"GL_DEPTH_RANGE", GL_DEPTH_RANGE},
    {"GL_DEPTH_WRITEMASK", GL_DEPTH_WRITEMASK},
    {"GL_DEPTH_COMPONENT", GL_DEPTH_COMPONENT},
    /* Lighting */
    {"GL_LIGHTING", GL_LIGHTING},
    {"GL_LIGHT0", GL_LIGHT0},
    {"GL_LIGHT1", GL_LIGHT1},
    {"GL_LIGHT2", GL_LIGHT2},
    {"GL_LIGHT3", GL_LIGHT3},
    {"GL_LIGHT4", GL_LIGHT4},
    {"GL_LIGHT5", GL_LIGHT5},
    {"GL_LIGHT6", GL_LIGHT6},
    {"GL_LIGHT7", GL_LIGHT7},
    {"GL_SPOT_EXPONENT", GL_SPOT_EXPONENT},
    {"GL_SPOT_CUTOFF", GL_SPOT_CUTOFF},
    {"GL_CONSTANT_ATTENUATION", GL_CONSTANT_ATTENUATION},
    {"GL_LINEAR_ATTENUATION", GL_LINEAR_ATTENUATION},
    {"GL_QUADRATIC_ATTENUATION", GL_QUADRATIC_ATTENUATION},
    {"GL_AMBIENT", GL_AMBIENT},
    {"GL_DIFFUSE", GL_DIFFUSE},
    {"GL_SPECULAR", GL_SPECULAR},
    {"GL_SHININESS", GL_SHININESS},
    {"GL_EMISSION", GL_EMISSION},
    {"GL_POSITION", GL_POSITION},
    {"GL_SPOT_DIRECTION", GL_SPOT_DIRECTION},
    {"GL_AMBIENT_AND_DIFFUSE", GL_AMBIENT_AND_DIFFUSE},
    {"GL_COLOR_INDEXES", GL_COLOR_INDEXES},
    {"GL_LIGHT_MODEL_TWO_SIDE", GL_LIGHT_MODEL_TWO_SIDE},
    {"GL_LIGHT_MODEL_LOCAL_VIEWER", GL_LIGHT_MODEL_LOCAL_VIEWER},
    {"GL_LIGHT_MODEL_AMBIENT", GL_LIGHT_MODEL_AMBIENT},
    {"GL_FRONT_AND_BACK", GL_FRONT_AND_BACK},
    {"GL_SHADE_MODEL", GL_SHADE_MODEL},
    {"GL_FLAT", GL_FLAT},
    {"GL_SMOOTH", GL_SMOOTH},
    {"GL_COLOR_MATERIAL", GL_COLOR_MATERIAL},
    {"GL_COLOR_MATERIAL_FACE", GL_COLOR_MATERIAL_FACE},
    {"GL_COLOR_MATERIAL_PARAMETER", GL_COLOR_MATERIAL_PARAMETER},
    {"GL_NORMALIZE", GL_NORMALIZE},
    /* User clipping planes */
    {"GL_CLIP_PLANE0", GL_CLIP_PLANE0},
    {"GL_CLIP_PLANE1", GL_CLIP_PLANE1},
    {"GL_CLIP_PLANE2", GL_CLIP_PLANE2},
    {"GL_CLIP_PLANE3", GL_CLIP_PLANE3},
    {"GL_CLIP_PLANE4", GL_CLIP_PLANE4},
    {"GL_CLIP_PLANE5", GL_CLIP_PLANE5},
    /* Accumulation buffer */
    {"GL_ACCUM_RED_BITS", GL_ACCUM_RED_BITS},
    {"GL_ACCUM_GREEN_BITS", GL_ACCUM_GREEN_BITS},
    {"GL_ACCUM_BLUE_BITS", GL_ACCUM_BLUE_BITS},
    {"GL_ACCUM_ALPHA_BITS", GL_ACCUM_ALPHA_BITS},
    {"GL_ACCUM_CLEAR_VALUE", GL_ACCUM_CLEAR_VALUE},
    {"GL_ACCUM", GL_ACCUM},
    {"GL_ADD", GL_ADD},
    {"GL_LOAD", GL_LOAD},
    {"GL_MULT", GL_MULT},
    {"GL_RETURN", GL_RETURN},
    /* Alpha testing */
    {"GL_ALPHA_TEST", GL_ALPHA_TEST},
    {"GL_ALPHA_TEST_REF", GL_ALPHA_TEST_REF},
    {"GL_ALPHA_TEST_FUNC", GL_ALPHA_TEST_FUNC},
    /* Blending */
    {"GL_BLEND", GL_BLEND},
    {"GL_BLEND_SRC", GL_BLEND_SRC},
    {"GL_BLEND_DST", GL_BLEND_DST},
    {"GL_ZERO", GL_ZERO},
    {"GL_ONE", GL_ONE},
    {"GL_SRC_COLOR", GL_SRC_COLOR},
    {"GL_ONE_MINUS_SRC_COLOR", GL_ONE_MINUS_SRC_COLOR},
    {"GL_DST_COLOR", GL_DST_COLOR},
    {"GL_ONE_MINUS_DST_COLOR", GL_ONE_MINUS_DST_COLOR},
    {"GL_SRC_ALPHA", GL_SRC_ALPHA},
    {"GL_ONE_MINUS_SRC_ALPHA", GL_ONE_MINUS_SRC_ALPHA},
    {"GL_DST_ALPHA", GL_DST_ALPHA},
    {"GL_ONE_MINUS_DST_ALPHA", GL_ONE_MINUS_DST_ALPHA},
    {"GL_SRC_ALPHA_SATURATE", GL_SRC_ALPHA_SATURATE},
#ifndef WIN32
    {"GL_CONSTANT_COLOR", GL_CONSTANT_COLOR},
    {"GL_ONE_MINUS_CONSTANT_COLOR", GL_ONE_MINUS_CONSTANT_COLOR},
    {"GL_CONSTANT_ALPHA", GL_CONSTANT_ALPHA},
    {"GL_ONE_MINUS_CONSTANT_ALPHA", GL_ONE_MINUS_CONSTANT_ALPHA},
#endif /* WIN32 */
    /* Render Mode */
    {"GL_FEEDBACK", GL_FEEDBACK},
    {"GL_RENDER", GL_RENDER},
    {"GL_SELECT", GL_SELECT},
    /* Feedback */
    {"GL_2D", GL_2D},
    {"GL_3D", GL_3D},
    {"GL_3D_COLOR", GL_3D_COLOR},
    {"GL_3D_COLOR_TEXTURE", GL_3D_COLOR_TEXTURE},
    {"GL_4D_COLOR_TEXTURE", GL_4D_COLOR_TEXTURE},
    {"GL_POINT_TOKEN", GL_POINT_TOKEN},
    {"GL_LINE_TOKEN", GL_LINE_TOKEN},
    {"GL_LINE_RESET_TOKEN", GL_LINE_RESET_TOKEN},
    {"GL_POLYGON_TOKEN", GL_POLYGON_TOKEN},
    {"GL_BITMAP_TOKEN", GL_BITMAP_TOKEN},
    {"GL_DRAW_PIXEL_TOKEN", GL_DRAW_PIXEL_TOKEN},
    {"GL_COPY_PIXEL_TOKEN", GL_COPY_PIXEL_TOKEN},
    {"GL_PASS_THROUGH_TOKEN", GL_PASS_THROUGH_TOKEN},
    {"GL_FEEDBACK_BUFFER_POINTER", GL_FEEDBACK_BUFFER_POINTER},
    {"GL_FEEDBACK_BUFFER_SIZE", GL_FEEDBACK_BUFFER_SIZE},
    {"GL_FEEDBACK_BUFFER_TYPE", GL_FEEDBACK_BUFFER_TYPE},
    /* Selection */
    {"GL_SELECTION_BUFFER_POINTER", GL_SELECTION_BUFFER_POINTER},
    {"GL_SELECTION_BUFFER_SIZE", GL_SELECTION_BUFFER_SIZE},
    /* Fog */
    {"GL_FOG", GL_FOG},
    {"GL_FOG_MODE", GL_FOG_MODE},
    {"GL_FOG_DENSITY", GL_FOG_DENSITY},
    {"GL_FOG_COLOR", GL_FOG_COLOR},
    {"GL_FOG_INDEX", GL_FOG_INDEX},
    {"GL_FOG_START", GL_FOG_START},
    {"GL_FOG_END", GL_FOG_END},
    {"GL_LINEAR", GL_LINEAR},
    {"GL_EXP", GL_EXP},
    {"GL_EXP2", GL_EXP2},
    /* Logic Ops */
    {"GL_LOGIC_OP", GL_LOGIC_OP},
    {"GL_INDEX_LOGIC_OP", GL_INDEX_LOGIC_OP},
    {"GL_COLOR_LOGIC_OP", GL_COLOR_LOGIC_OP},
    {"GL_LOGIC_OP_MODE", GL_LOGIC_OP_MODE},
    {"GL_CLEAR", GL_CLEAR},
    {"GL_SET", GL_SET},
    {"GL_COPY", GL_COPY},
    {"GL_COPY_INVERTED", GL_COPY_INVERTED},
    {"GL_NOOP", GL_NOOP},
    {"GL_INVERT", GL_INVERT},
    {"GL_AND", GL_AND},
    {"GL_NAND", GL_NAND},
    {"GL_OR", GL_OR},
    {"GL_NOR", GL_NOR},
    {"GL_XOR", GL_XOR},
    {"GL_EQUIV", GL_EQUIV},
    {"GL_AND_REVERSE", GL_AND_REVERSE},
    {"GL_AND_INVERTED", GL_AND_INVERTED},
    {"GL_OR_REVERSE", GL_OR_REVERSE},
    {"GL_OR_INVERTED", GL_OR_INVERTED},
    /* Stencil */
    {"GL_STENCIL_TEST", GL_STENCIL_TEST},
    {"GL_STENCIL_WRITEMASK", GL_STENCIL_WRITEMASK},
    {"GL_STENCIL_BITS", GL_STENCIL_BITS},
    {"GL_STENCIL_FUNC", GL_STENCIL_FUNC},
    {"GL_STENCIL_VALUE_MASK", GL_STENCIL_VALUE_MASK},
    {"GL_STENCIL_REF", GL_STENCIL_REF},
    {"GL_STENCIL_FAIL", GL_STENCIL_FAIL},
    {"GL_STENCIL_PASS_DEPTH_PASS", GL_STENCIL_PASS_DEPTH_PASS},
    {"GL_STENCIL_PASS_DEPTH_FAIL", GL_STENCIL_PASS_DEPTH_FAIL},
    {"GL_STENCIL_CLEAR_VALUE", GL_STENCIL_CLEAR_VALUE},
    {"GL_STENCIL_INDEX", GL_STENCIL_INDEX},
    {"GL_KEEP", GL_KEEP},
    {"GL_REPLACE", GL_REPLACE},
    {"GL_INCR", GL_INCR},
    {"GL_DECR", GL_DECR},
    /* Buffers Pixel Drawing/Reading */
    {"GL_NONE", GL_NONE},
    {"GL_LEFT", GL_LEFT},
    {"GL_RIGHT", GL_RIGHT},
    {"GL_FRONT", GL_FRONT},
    {"GL_BACK", GL_BACK},
    {"GL_FRONT_AND_BACK", GL_FRONT_AND_BACK},
    {"GL_FRONT_LEFT", GL_FRONT_LEFT},
    {"GL_FRONT_RIGHT", GL_FRONT_RIGHT},
    {"GL_BACK_LEFT", GL_BACK_LEFT},
    {"GL_BACK_RIGHT", GL_BACK_RIGHT},
    {"GL_AUX0", GL_AUX0},
    {"GL_AUX1", GL_AUX1},
    {"GL_AUX2", GL_AUX2},
    {"GL_AUX3", GL_AUX3},
    {"GL_COLOR_INDEX", GL_COLOR_INDEX},
    {"GL_RED", GL_RED},
    {"GL_GREEN", GL_GREEN},
    {"GL_BLUE", GL_BLUE},
    {"GL_ALPHA", GL_ALPHA},
    {"GL_LUMINANCE", GL_LUMINANCE},
    {"GL_LUMINANCE_ALPHA", GL_LUMINANCE_ALPHA},
    {"GL_ALPHA_BITS", GL_ALPHA_BITS},
    {"GL_RED_BITS", GL_RED_BITS},
    {"GL_GREEN_BITS", GL_GREEN_BITS},
    {"GL_BLUE_BITS", GL_BLUE_BITS},
    {"GL_INDEX_BITS", GL_INDEX_BITS},
    {"GL_SUBPIXEL_BITS", GL_SUBPIXEL_BITS},
    {"GL_AUX_BUFFERS", GL_AUX_BUFFERS},
    {"GL_READ_BUFFER", GL_READ_BUFFER},
    {"GL_DRAW_BUFFER", GL_DRAW_BUFFER},
    {"GL_DOUBLEBUFFER", GL_DOUBLEBUFFER},
    {"GL_STEREO", GL_STEREO},
    {"GL_BITMAP", GL_BITMAP},
    {"GL_COLOR", GL_COLOR},
    {"GL_DEPTH", GL_DEPTH},
    {"GL_STENCIL", GL_STENCIL},
    {"GL_DITHER", GL_DITHER},
    {"GL_RGB", GL_RGB},
    {"GL_RGBA", GL_RGBA},
    /* Implementation limits */
    {"GL_MAX_LIST_NESTING", GL_MAX_LIST_NESTING},
    {"GL_MAX_ATTRIB_STACK_DEPTH", GL_MAX_ATTRIB_STACK_DEPTH},
    {"GL_MAX_MODELVIEW_STACK_DEPTH", GL_MAX_MODELVIEW_STACK_DEPTH},
    {"GL_MAX_NAME_STACK_DEPTH", GL_MAX_NAME_STACK_DEPTH},
    {"GL_MAX_PROJECTION_STACK_DEPTH", GL_MAX_PROJECTION_STACK_DEPTH},
    {"GL_MAX_TEXTURE_STACK_DEPTH", GL_MAX_TEXTURE_STACK_DEPTH},
    {"GL_MAX_EVAL_ORDER", GL_MAX_EVAL_ORDER},
    {"GL_MAX_LIGHTS", GL_MAX_LIGHTS},
    {"GL_MAX_CLIP_PLANES", GL_MAX_CLIP_PLANES},
    {"GL_MAX_TEXTURE_SIZE", GL_MAX_TEXTURE_SIZE},
    {"GL_MAX_PIXEL_MAP_TABLE", GL_MAX_PIXEL_MAP_TABLE},
    {"GL_MAX_VIEWPORT_DIMS", GL_MAX_VIEWPORT_DIMS},
    {"GL_MAX_CLIENT_ATTRIB_STACK_DEPTH", GL_MAX_CLIENT_ATTRIB_STACK_DEPTH},
    /* Gets */
    {"GL_ATTRIB_STACK_DEPTH", GL_ATTRIB_STACK_DEPTH},
    {"GL_CLIENT_ATTRIB_STACK_DEPTH", GL_CLIENT_ATTRIB_STACK_DEPTH},
    {"GL_COLOR_CLEAR_VALUE", GL_COLOR_CLEAR_VALUE},
    {"GL_COLOR_WRITEMASK", GL_COLOR_WRITEMASK},
    {"GL_CURRENT_INDEX", GL_CURRENT_INDEX},
    {"GL_CURRENT_COLOR", GL_CURRENT_COLOR},
    {"GL_CURRENT_NORMAL", GL_CURRENT_NORMAL},
    {"GL_CURRENT_RASTER_COLOR", GL_CURRENT_RASTER_COLOR},
    {"GL_CURRENT_RASTER_DISTANCE", GL_CURRENT_RASTER_DISTANCE},
    {"GL_CURRENT_RASTER_INDEX", GL_CURRENT_RASTER_INDEX},
    {"GL_CURRENT_RASTER_POSITION", GL_CURRENT_RASTER_POSITION},
    {"GL_CURRENT_RASTER_TEXTURE_COORDS", GL_CURRENT_RASTER_TEXTURE_COORDS},
    {"GL_CURRENT_RASTER_POSITION_VALID", GL_CURRENT_RASTER_POSITION_VALID},
    {"GL_CURRENT_TEXTURE_COORDS", GL_CURRENT_TEXTURE_COORDS},
    {"GL_INDEX_CLEAR_VALUE", GL_INDEX_CLEAR_VALUE},
    {"GL_INDEX_MODE", GL_INDEX_MODE},
    {"GL_INDEX_WRITEMASK", GL_INDEX_WRITEMASK},
    {"GL_MODELVIEW_MATRIX", GL_MODELVIEW_MATRIX},
    {"GL_MODELVIEW_STACK_DEPTH", GL_MODELVIEW_STACK_DEPTH},
    {"GL_NAME_STACK_DEPTH", GL_NAME_STACK_DEPTH},
    {"GL_PROJECTION_MATRIX", GL_PROJECTION_MATRIX},
    {"GL_PROJECTION_STACK_DEPTH", GL_PROJECTION_STACK_DEPTH},
    {"GL_RENDER_MODE", GL_RENDER_MODE},
    {"GL_RGBA_MODE", GL_RGBA_MODE},
    {"GL_TEXTURE_MATRIX", GL_TEXTURE_MATRIX},
    {"GL_TEXTURE_STACK_DEPTH", GL_TEXTURE_STACK_DEPTH},
    {"GL_VIEWPORT", GL_VIEWPORT},
    /* Evaluators */
    {"GL_AUTO_NORMAL", GL_AUTO_NORMAL},
    {"GL_MAP1_COLOR_4", GL_MAP1_COLOR_4},
    {"GL_MAP1_GRID_DOMAIN", GL_MAP1_GRID_DOMAIN},
    {"GL_MAP1_GRID_SEGMENTS", GL_MAP1_GRID_SEGMENTS},
    {"GL_MAP1_INDEX", GL_MAP1_INDEX},
    {"GL_MAP1_NORMAL", GL_MAP1_NORMAL},
    {"GL_MAP1_TEXTURE_COORD_1", GL_MAP1_TEXTURE_COORD_1},
    {"GL_MAP1_TEXTURE_COORD_2", GL_MAP1_TEXTURE_COORD_2},
    {"GL_MAP1_TEXTURE_COORD_3", GL_MAP1_TEXTURE_COORD_3},
    {"GL_MAP1_TEXTURE_COORD_4", GL_MAP1_TEXTURE_COORD_4},
    {"GL_MAP1_VERTEX_3", GL_MAP1_VERTEX_3},
    {"GL_MAP1_VERTEX_4", GL_MAP1_VERTEX_4},
    {"GL_MAP2_COLOR_4", GL_MAP2_COLOR_4},
    {"GL_MAP2_GRID_DOMAIN", GL_MAP2_GRID_DOMAIN},
    {"GL_MAP2_GRID_SEGMENTS", GL_MAP2_GRID_SEGMENTS},
    {"GL_MAP2_INDEX", GL_MAP2_INDEX},
    {"GL_MAP2_NORMAL", GL_MAP2_NORMAL},
    {"GL_MAP2_TEXTURE_COORD_1", GL_MAP2_TEXTURE_COORD_1},
    {"GL_MAP2_TEXTURE_COORD_2", GL_MAP2_TEXTURE_COORD_2},
    {"GL_MAP2_TEXTURE_COORD_3", GL_MAP2_TEXTURE_COORD_3},
    {"GL_MAP2_TEXTURE_COORD_4", GL_MAP2_TEXTURE_COORD_4},
    {"GL_MAP2_VERTEX_3", GL_MAP2_VERTEX_3},
    {"GL_MAP2_VERTEX_4", GL_MAP2_VERTEX_4},
    {"GL_COEFF", GL_COEFF},
    {"GL_DOMAIN", GL_DOMAIN},
    {"GL_ORDER", GL_ORDER},
    /* Hints */
    {"GL_FOG_HINT", GL_FOG_HINT},
    {"GL_LINE_SMOOTH_HINT", GL_LINE_SMOOTH_HINT},
    {"GL_PERSPECTIVE_CORRECTION_HINT", GL_PERSPECTIVE_CORRECTION_HINT},
    {"GL_POINT_SMOOTH_HINT", GL_POINT_SMOOTH_HINT},
    {"GL_POLYGON_SMOOTH_HINT", GL_POLYGON_SMOOTH_HINT},
    {"GL_DONT_CARE", GL_DONT_CARE},
    {"GL_FASTEST", GL_FASTEST},
    {"GL_NICEST", GL_NICEST},
    /* Scissor box */
    {"GL_SCISSOR_TEST", GL_SCISSOR_TEST},
    {"GL_SCISSOR_BOX", GL_SCISSOR_BOX},
    /* Pixel Mode / Transfer */
    {"GL_MAP_COLOR", GL_MAP_COLOR},
    {"GL_MAP_STENCIL", GL_MAP_STENCIL},
    {"GL_INDEX_SHIFT", GL_INDEX_SHIFT},
    {"GL_INDEX_OFFSET", GL_INDEX_OFFSET},
    {"GL_RED_SCALE", GL_RED_SCALE},
    {"GL_RED_BIAS", GL_RED_BIAS},
    {"GL_GREEN_SCALE", GL_GREEN_SCALE},
    {"GL_GREEN_BIAS", GL_GREEN_BIAS},
    {"GL_BLUE_SCALE", GL_BLUE_SCALE},
    {"GL_BLUE_BIAS", GL_BLUE_BIAS},
    {"GL_ALPHA_SCALE", GL_ALPHA_SCALE},
    {"GL_ALPHA_BIAS", GL_ALPHA_BIAS},
    {"GL_DEPTH_SCALE", GL_DEPTH_SCALE},
    {"GL_DEPTH_BIAS", GL_DEPTH_BIAS},
    {"GL_PIXEL_MAP_S_TO_S_SIZE", GL_PIXEL_MAP_S_TO_S_SIZE},
    {"GL_PIXEL_MAP_I_TO_I_SIZE", GL_PIXEL_MAP_I_TO_I_SIZE},
    {"GL_PIXEL_MAP_I_TO_R_SIZE", GL_PIXEL_MAP_I_TO_R_SIZE},
    {"GL_PIXEL_MAP_I_TO_G_SIZE", GL_PIXEL_MAP_I_TO_G_SIZE},
    {"GL_PIXEL_MAP_I_TO_B_SIZE", GL_PIXEL_MAP_I_TO_B_SIZE},
    {"GL_PIXEL_MAP_I_TO_A_SIZE", GL_PIXEL_MAP_I_TO_A_SIZE},
    {"GL_PIXEL_MAP_R_TO_R_SIZE", GL_PIXEL_MAP_R_TO_R_SIZE},
    {"GL_PIXEL_MAP_G_TO_G_SIZE", GL_PIXEL_MAP_G_TO_G_SIZE},
    {"GL_PIXEL_MAP_B_TO_B_SIZE", GL_PIXEL_MAP_B_TO_B_SIZE},
    {"GL_PIXEL_MAP_A_TO_A_SIZE", GL_PIXEL_MAP_A_TO_A_SIZE},
    {"GL_PIXEL_MAP_S_TO_S", GL_PIXEL_MAP_S_TO_S},
    {"GL_PIXEL_MAP_I_TO_I", GL_PIXEL_MAP_I_TO_I},
    {"GL_PIXEL_MAP_I_TO_R", GL_PIXEL_MAP_I_TO_R},
    {"GL_PIXEL_MAP_I_TO_G", GL_PIXEL_MAP_I_TO_G},
    {"GL_PIXEL_MAP_I_TO_B", GL_PIXEL_MAP_I_TO_B},
    {"GL_PIXEL_MAP_I_TO_A", GL_PIXEL_MAP_I_TO_A},
    {"GL_PIXEL_MAP_R_TO_R", GL_PIXEL_MAP_R_TO_R},
    {"GL_PIXEL_MAP_G_TO_G", GL_PIXEL_MAP_G_TO_G},
    {"GL_PIXEL_MAP_B_TO_B", GL_PIXEL_MAP_B_TO_B},
    {"GL_PIXEL_MAP_A_TO_A", GL_PIXEL_MAP_A_TO_A},
    {"GL_PACK_ALIGNMENT", GL_PACK_ALIGNMENT},
    {"GL_PACK_LSB_FIRST", GL_PACK_LSB_FIRST},
    {"GL_PACK_ROW_LENGTH", GL_PACK_ROW_LENGTH},
    {"GL_PACK_SKIP_PIXELS", GL_PACK_SKIP_PIXELS},
    {"GL_PACK_SKIP_ROWS", GL_PACK_SKIP_ROWS},
    {"GL_PACK_SWAP_BYTES", GL_PACK_SWAP_BYTES},
    {"GL_UNPACK_ALIGNMENT", GL_UNPACK_ALIGNMENT},
    {"GL_UNPACK_LSB_FIRST", GL_UNPACK_LSB_FIRST},
    {"GL_UNPACK_ROW_LENGTH", GL_UNPACK_ROW_LENGTH},
    {"GL_UNPACK_SKIP_PIXELS", GL_UNPACK_SKIP_PIXELS},
    {"GL_UNPACK_SKIP_ROWS", GL_UNPACK_SKIP_ROWS},
    {"GL_UNPACK_SWAP_BYTES", GL_UNPACK_SWAP_BYTES},
    {"GL_ZOOM_X", GL_ZOOM_X},
    {"GL_ZOOM_Y", GL_ZOOM_Y},
    /* Texture mapping */
    {"GL_TEXTURE_ENV", GL_TEXTURE_ENV},
    {"GL_TEXTURE_ENV_MODE", GL_TEXTURE_ENV_MODE},
    {"GL_TEXTURE_1D", GL_TEXTURE_1D},
    {"GL_TEXTURE_2D", GL_TEXTURE_2D},
    {"GL_TEXTURE_WRAP_S", GL_TEXTURE_WRAP_S},
    {"GL_TEXTURE_WRAP_T", GL_TEXTURE_WRAP_T},
    {"GL_TEXTURE_MAG_FILTER", GL_TEXTURE_MAG_FILTER},
    {"GL_TEXTURE_MIN_FILTER", GL_TEXTURE_MIN_FILTER},
    {"GL_TEXTURE_ENV_COLOR", GL_TEXTURE_ENV_COLOR},
    {"GL_TEXTURE_GEN_S", GL_TEXTURE_GEN_S},
    {"GL_TEXTURE_GEN_T", GL_TEXTURE_GEN_T},
    {"GL_TEXTURE_GEN_MODE", GL_TEXTURE_GEN_MODE},
    {"GL_TEXTURE_BORDER_COLOR", GL_TEXTURE_BORDER_COLOR},
    {"GL_TEXTURE_WIDTH", GL_TEXTURE_WIDTH},
    {"GL_TEXTURE_HEIGHT", GL_TEXTURE_HEIGHT},
    {"GL_TEXTURE_BORDER", GL_TEXTURE_BORDER},
    {"GL_TEXTURE_COMPONENTS", GL_TEXTURE_COMPONENTS},
    {"GL_TEXTURE_RED_SIZE", GL_TEXTURE_RED_SIZE},
    {"GL_TEXTURE_GREEN_SIZE", GL_TEXTURE_GREEN_SIZE},
    {"GL_TEXTURE_BLUE_SIZE", GL_TEXTURE_BLUE_SIZE},
    {"GL_TEXTURE_ALPHA_SIZE", GL_TEXTURE_ALPHA_SIZE},
    {"GL_TEXTURE_LUMINANCE_SIZE", GL_TEXTURE_LUMINANCE_SIZE},
    {"GL_TEXTURE_INTENSITY_SIZE", GL_TEXTURE_INTENSITY_SIZE},
    {"GL_NEAREST_MIPMAP_NEAREST", GL_NEAREST_MIPMAP_NEAREST},
    {"GL_NEAREST_MIPMAP_LINEAR", GL_NEAREST_MIPMAP_LINEAR},
    {"GL_LINEAR_MIPMAP_NEAREST", GL_LINEAR_MIPMAP_NEAREST},
    {"GL_LINEAR_MIPMAP_LINEAR", GL_LINEAR_MIPMAP_LINEAR},
    {"GL_OBJECT_LINEAR", GL_OBJECT_LINEAR},
    {"GL_OBJECT_PLANE", GL_OBJECT_PLANE},
    {"GL_EYE_LINEAR", GL_EYE_LINEAR},
    {"GL_EYE_PLANE", GL_EYE_PLANE},
    {"GL_SPHERE_MAP", GL_SPHERE_MAP},
    {"GL_DECAL", GL_DECAL},
    {"GL_MODULATE", GL_MODULATE},
    {"GL_NEAREST", GL_NEAREST},
    {"GL_REPEAT", GL_REPEAT},
    {"GL_CLAMP", GL_CLAMP},
    {"GL_S", GL_S},
    {"GL_T", GL_T},
    {"GL_R", GL_R},
    {"GL_Q", GL_Q},
    {"GL_TEXTURE_GEN_R", GL_TEXTURE_GEN_R},
    {"GL_TEXTURE_GEN_Q", GL_TEXTURE_GEN_Q},
    /* GL 1.1 texturing */
    {"GL_PROXY_TEXTURE_1D", GL_PROXY_TEXTURE_1D},
    {"GL_PROXY_TEXTURE_2D", GL_PROXY_TEXTURE_2D},
    {"GL_TEXTURE_PRIORITY", GL_TEXTURE_PRIORITY},
    {"GL_TEXTURE_RESIDENT", GL_TEXTURE_RESIDENT},
    {"GL_TEXTURE_BINDING_1D", GL_TEXTURE_BINDING_1D},
    {"GL_TEXTURE_BINDING_2D", GL_TEXTURE_BINDING_2D},
    {"GL_TEXTURE_INTERNAL_FORMAT", GL_TEXTURE_INTERNAL_FORMAT},
#ifdef GL12
    /* GL 1.2 texturing */
    {"GL_PACK_SKIP_IMAGES", GL_PACK_SKIP_IMAGES},
    {"GL_PACK_IMAGE_HEIGHT", GL_PACK_IMAGE_HEIGHT},
    {"GL_UNPACK_SKIP_IMAGES", GL_UNPACK_SKIP_IMAGES},
    {"GL_UNPACK_IMAGE_HEIGHT", GL_UNPACK_IMAGE_HEIGHT},
    {"GL_TEXTURE_3D", GL_TEXTURE_3D},
    {"GL_PROXY_TEXTURE_3D", GL_PROXY_TEXTURE_3D},
    {"GL_TEXTURE_DEPTH", GL_TEXTURE_DEPTH},
    {"GL_TEXTURE_WRAP_R", GL_TEXTURE_WRAP_R},
    {"GL_MAX_3D_TEXTURE_SIZE", GL_MAX_3D_TEXTURE_SIZE},
    {"GL_TEXTURE_BINDING_3D", GL_TEXTURE_BINDING_3D},
#endif /*GL12 */
    /* Internal texture formats (GL 1.1) */
    {"GL_ALPHA4", GL_ALPHA4},
    {"GL_ALPHA8", GL_ALPHA8},
    {"GL_ALPHA12", GL_ALPHA12},
    {"GL_ALPHA16", GL_ALPHA16},
    {"GL_LUMINANCE4", GL_LUMINANCE4},
    {"GL_LUMINANCE8", GL_LUMINANCE8},
    {"GL_LUMINANCE12", GL_LUMINANCE12},
    {"GL_LUMINANCE16", GL_LUMINANCE16},
    {"GL_LUMINANCE4_ALPHA4", GL_LUMINANCE4_ALPHA4},
    {"GL_LUMINANCE6_ALPHA2", GL_LUMINANCE6_ALPHA2},
    {"GL_LUMINANCE8_ALPHA8", GL_LUMINANCE8_ALPHA8},
    {"GL_LUMINANCE12_ALPHA4", GL_LUMINANCE12_ALPHA4},
    {"GL_LUMINANCE12_ALPHA12", GL_LUMINANCE12_ALPHA12},
    {"GL_LUMINANCE16_ALPHA16", GL_LUMINANCE16_ALPHA16},
    {"GL_INTENSITY", GL_INTENSITY},
    {"GL_INTENSITY4", GL_INTENSITY4},
    {"GL_INTENSITY8", GL_INTENSITY8},
    {"GL_INTENSITY12", GL_INTENSITY12},
    {"GL_INTENSITY16", GL_INTENSITY16},
    {"GL_R3_G3_B2", GL_R3_G3_B2},
    {"GL_RGB4", GL_RGB4},
    {"GL_RGB5", GL_RGB5},
    {"GL_RGB8", GL_RGB8},
    {"GL_RGB10", GL_RGB10},
    {"GL_RGB12", GL_RGB12},
    {"GL_RGB16", GL_RGB16},
    {"GL_RGBA2", GL_RGBA2},
    {"GL_RGBA4", GL_RGBA4},
    {"GL_RGB5_A1", GL_RGB5_A1},
    {"GL_RGBA8", GL_RGBA8},
    {"GL_RGB10_A2", GL_RGB10_A2},
    {"GL_RGBA12", GL_RGBA12},
    {"GL_RGBA16", GL_RGBA16},
    /* Utility */
    {"GL_VENDOR", GL_VENDOR},
    {"GL_RENDERER", GL_RENDERER},
    {"GL_VERSION", GL_VERSION},
    {"GL_EXTENSIONS", GL_EXTENSIONS},
    /* Errors */
    {"GL_NO_ERROR", GL_NO_ERROR},
    {"GL_INVALID_VALUE", GL_INVALID_VALUE},
    {"GL_INVALID_ENUM", GL_INVALID_ENUM},
    {"GL_INVALID_OPERATION", GL_INVALID_OPERATION},
    {"GL_STACK_OVERFLOW", GL_STACK_OVERFLOW},
    {"GL_STACK_UNDERFLOW", GL_STACK_UNDERFLOW},
    {"GL_OUT_OF_MEMORY", GL_OUT_OF_MEMORY},
#ifdef GLEXT
    /* GL_EXT_blend_minmax and GL_EXT_blend_color */
    {"GL_CONSTANT_COLOR_EXT", GL_CONSTANT_COLOR_EXT},
    {"GL_ONE_MINUS_CONSTANT_COLOR_EXT", GL_ONE_MINUS_CONSTANT_COLOR_EXT},
    {"GL_CONSTANT_ALPHA_EXT", GL_CONSTANT_ALPHA_EXT},
    {"GL_ONE_MINUS_CONSTANT_ALPHA_EXT", GL_ONE_MINUS_CONSTANT_ALPHA_EXT},
    {"GL_BLEND_EQUATION_EXT", GL_BLEND_EQUATION_EXT},
    {"GL_MIN_EXT", GL_MIN_EXT},
    {"GL_MAX_EXT", GL_MAX_EXT},
    {"GL_FUNC_ADD_EXT", GL_FUNC_ADD_EXT},
    {"GL_FUNC_SUBTRACT_EXT", GL_FUNC_SUBTRACT_EXT},
    {"GL_FUNC_REVERSE_SUBTRACT_EXT", GL_FUNC_REVERSE_SUBTRACT_EXT},
    {"GL_BLEND_COLOR_EXT", GL_BLEND_COLOR_EXT},
    /* GL_EXT_polygon_offset */
    {"GL_POLYGON_OFFSET_EXT", GL_POLYGON_OFFSET_EXT},
    {"GL_POLYGON_OFFSET_FACTOR_EXT", GL_POLYGON_OFFSET_FACTOR_EXT},
    {"GL_POLYGON_OFFSET_BIAS_EXT", GL_POLYGON_OFFSET_BIAS_EXT},
    /* GL_EXT_vertex_array */
    {"GL_VERTEX_ARRAY_EXT", GL_VERTEX_ARRAY_EXT},
    {"GL_NORMAL_ARRAY_EXT", GL_NORMAL_ARRAY_EXT},
    {"GL_COLOR_ARRAY_EXT", GL_COLOR_ARRAY_EXT},
    {"GL_INDEX_ARRAY_EXT", GL_INDEX_ARRAY_EXT},
    {"GL_TEXTURE_COORD_ARRAY_EXT", GL_TEXTURE_COORD_ARRAY_EXT},
    {"GL_EDGE_FLAG_ARRAY_EXT", GL_EDGE_FLAG_ARRAY_EXT},
    {"GL_VERTEX_ARRAY_SIZE_EXT", GL_VERTEX_ARRAY_SIZE_EXT},
    {"GL_VERTEX_ARRAY_TYPE_EXT", GL_VERTEX_ARRAY_TYPE_EXT},
    {"GL_VERTEX_ARRAY_STRIDE_EXT", GL_VERTEX_ARRAY_STRIDE_EXT},
    {"GL_VERTEX_ARRAY_COUNT_EXT", GL_VERTEX_ARRAY_COUNT_EXT},
    {"GL_NORMAL_ARRAY_TYPE_EXT", GL_NORMAL_ARRAY_TYPE_EXT},
    {"GL_NORMAL_ARRAY_STRIDE_EXT", GL_NORMAL_ARRAY_STRIDE_EXT},
    {"GL_NORMAL_ARRAY_COUNT_EXT", GL_NORMAL_ARRAY_COUNT_EXT},
    {"GL_COLOR_ARRAY_SIZE_EXT", GL_COLOR_ARRAY_SIZE_EXT},
    {"GL_COLOR_ARRAY_TYPE_EXT", GL_COLOR_ARRAY_TYPE_EXT},
    {"GL_COLOR_ARRAY_STRIDE_EXT", GL_COLOR_ARRAY_STRIDE_EXT},
    {"GL_COLOR_ARRAY_COUNT_EXT", GL_COLOR_ARRAY_COUNT_EXT},
    {"GL_INDEX_ARRAY_TYPE_EXT", GL_INDEX_ARRAY_TYPE_EXT},
    {"GL_INDEX_ARRAY_STRIDE_EXT", GL_INDEX_ARRAY_STRIDE_EXT},
    {"GL_INDEX_ARRAY_COUNT_EXT", GL_INDEX_ARRAY_COUNT_EXT},
    {"GL_TEXTURE_COORD_ARRAY_SIZE_EXT", GL_TEXTURE_COORD_ARRAY_SIZE_EXT},
    {"GL_TEXTURE_COORD_ARRAY_TYPE_EXT", GL_TEXTURE_COORD_ARRAY_TYPE_EXT},
    {"GL_TEXTURE_COORD_ARRAY_STRIDE_EXT", GL_TEXTURE_COORD_ARRAY_STRIDE_EXT},
    {"GL_TEXTURE_COORD_ARRAY_COUNT_EXT", GL_TEXTURE_COORD_ARRAY_COUNT_EXT},
    {"GL_EDGE_FLAG_ARRAY_STRIDE_EXT", GL_EDGE_FLAG_ARRAY_STRIDE_EXT},
    {"GL_EDGE_FLAG_ARRAY_COUNT_EXT", GL_EDGE_FLAG_ARRAY_COUNT_EXT},
    {"GL_VERTEX_ARRAY_POINTER_EXT", GL_VERTEX_ARRAY_POINTER_EXT},
    {"GL_NORMAL_ARRAY_POINTER_EXT", GL_NORMAL_ARRAY_POINTER_EXT},
    {"GL_COLOR_ARRAY_POINTER_EXT", GL_COLOR_ARRAY_POINTER_EXT},
    {"GL_INDEX_ARRAY_POINTER_EXT", GL_INDEX_ARRAY_POINTER_EXT},
    {"GL_TEXTURE_COORD_ARRAY_POINTER_EXT",
     GL_TEXTURE_COORD_ARRAY_POINTER_EXT},
    {"GL_EDGE_FLAG_ARRAY_POINTER_EXT", GL_EDGE_FLAG_ARRAY_POINTER_EXT},
    /* GL_EXT_texture_object */
    {"GL_TEXTURE_PRIORITY_EXT", GL_TEXTURE_PRIORITY_EXT},
    {"GL_TEXTURE_RESIDENT_EXT", GL_TEXTURE_RESIDENT_EXT},
    {"GL_TEXTURE_1D_BINDING_EXT", GL_TEXTURE_1D_BINDING_EXT},
    {"GL_TEXTURE_2D_BINDING_EXT", GL_TEXTURE_2D_BINDING_EXT},
    /* GL_EXT_texture3D */
    {"GL_PACK_SKIP_IMAGES_EXT", GL_PACK_SKIP_IMAGES_EXT},
    {"GL_PACK_IMAGE_HEIGHT_EXT", GL_PACK_IMAGE_HEIGHT_EXT},
    {"GL_UNPACK_SKIP_IMAGES_EXT", GL_UNPACK_SKIP_IMAGES_EXT},
    {"GL_UNPACK_IMAGE_HEIGHT_EXT", GL_UNPACK_IMAGE_HEIGHT_EXT},
    {"GL_TEXTURE_3D_EXT", GL_TEXTURE_3D_EXT},
    {"GL_PROXY_TEXTURE_3D_EXT", GL_PROXY_TEXTURE_3D_EXT},
    {"GL_TEXTURE_DEPTH_EXT", GL_TEXTURE_DEPTH_EXT},
    {"GL_TEXTURE_WRAP_R_EXT", GL_TEXTURE_WRAP_R_EXT},
    {"GL_MAX_3D_TEXTURE_SIZE_EXT", GL_MAX_3D_TEXTURE_SIZE_EXT},
    {"GL_TEXTURE_3D_BINDING_EXT", GL_TEXTURE_3D_BINDING_EXT},
    /* GL_EXT_paletted_texture */
    {"GL_TABLE_TOO_LARGE_EXT", GL_TABLE_TOO_LARGE_EXT},
    {"GL_COLOR_TABLE_FORMAT_EXT", GL_COLOR_TABLE_FORMAT_EXT},
    {"GL_COLOR_TABLE_WIDTH_EXT", GL_COLOR_TABLE_WIDTH_EXT},
    {"GL_COLOR_TABLE_RED_SIZE_EXT", GL_COLOR_TABLE_RED_SIZE_EXT},
    {"GL_COLOR_TABLE_GREEN_SIZE_EXT", GL_COLOR_TABLE_GREEN_SIZE_EXT},
    {"GL_COLOR_TABLE_BLUE_SIZE_EXT", GL_COLOR_TABLE_BLUE_SIZE_EXT},
    {"GL_COLOR_TABLE_ALPHA_SIZE_EXT", GL_COLOR_TABLE_ALPHA_SIZE_EXT},
    {"GL_COLOR_TABLE_LUMINANCE_SIZE_EXT", GL_COLOR_TABLE_LUMINANCE_SIZE_EXT},
    {"GL_COLOR_TABLE_INTENSITY_SIZE_EXT", GL_COLOR_TABLE_INTENSITY_SIZE_EXT},
    /*{"GL_TEXTURE_INDEX_SIZE_EXT", GL_TEXTURE_INDEX_SIZE_EXT}, */
    {"GL_COLOR_INDEX1_EXT", GL_COLOR_INDEX1_EXT},
    {"GL_COLOR_INDEX2_EXT", GL_COLOR_INDEX2_EXT},
    {"GL_COLOR_INDEX4_EXT", GL_COLOR_INDEX4_EXT},
    {"GL_COLOR_INDEX8_EXT", GL_COLOR_INDEX8_EXT},
    {"GL_COLOR_INDEX12_EXT", GL_COLOR_INDEX12_EXT},
    {"GL_COLOR_INDEX16_EXT", GL_COLOR_INDEX16_EXT},
    /* GL_EXT_shared_texture_palette */
    {"GL_SHARED_TEXTURE_PALETTE_EXT", GL_SHARED_TEXTURE_PALETTE_EXT},
    /* GL_EXT_point_parameters */
    {"GL_POINT_SIZE_MIN_EXT", GL_POINT_SIZE_MIN_EXT},
    {"GL_POINT_SIZE_MAX_EXT", GL_POINT_SIZE_MAX_EXT},
    {"GL_POINT_FADE_THRESHOLD_SIZE_EXT", GL_POINT_FADE_THRESHOLD_SIZE_EXT},
    {"GL_DISTANCE_ATTENUATION_EXT", GL_DISTANCE_ATTENUATION_EXT},
    /* GL_EXT_rescale_normal */
    {"GL_RESCALE_NORMAL_EXT", GL_RESCALE_NORMAL_EXT},
    /* GL_EXT_abgr */
    {"GL_ABGR_EXT", GL_ABGR_EXT},
#endif /*GLEXT*/
        /* GL_SGIS_multitexture */
#ifdef GLSGIS
    {"GL_SELECTED_TEXTURE_SGIS", GL_SELECTED_TEXTURE_SGIS},
    {"GL_SELECTED_TEXTURE_COORD_SET_SGIS",
     GL_SELECTED_TEXTURE_COORD_SET_SGIS},
    {"GL_MAX_TEXTURES_SGIS", GL_MAX_TEXTURES_SGIS},
    {"GL_TEXTURE0_SGIS", GL_TEXTURE0_SGIS},
    {"GL_TEXTURE1_SGIS", GL_TEXTURE1_SGIS},
    {"GL_TEXTURE2_SGIS", GL_TEXTURE2_SGIS},
    {"GL_TEXTURE3_SGIS", GL_TEXTURE3_SGIS},
    {"GL_TEXTURE_COORD_SET_SOURCE_SGIS", GL_TEXTURE_COORD_SET_SOURCE_SGIS},
#endif /*GLSGIS*/
#ifdef GLEXT
        /* GL_EXT_multitexture */
    {"GL_SELECTED_TEXTURE_EXT", GL_SELECTED_TEXTURE_EXT},
    {"GL_SELECTED_TEXTURE_COORD_SET_EXT", GL_SELECTED_TEXTURE_COORD_SET_EXT},
    {"GL_SELECTED_TEXTURE_TRANSFORM_EXT", GL_SELECTED_TEXTURE_TRANSFORM_EXT},
    {"GL_MAX_TEXTURES_EXT", GL_MAX_TEXTURES_EXT},
    {"GL_MAX_TEXTURE_COORD_SETS_EXT", GL_MAX_TEXTURE_COORD_SETS_EXT},
    {"GL_TEXTURE_ENV_COORD_SET_EXT", GL_TEXTURE_ENV_COORD_SET_EXT},
    {"GL_TEXTURE0_EXT", GL_TEXTURE0_EXT},
    {"GL_TEXTURE1_EXT", GL_TEXTURE1_EXT},
    {"GL_TEXTURE2_EXT", GL_TEXTURE2_EXT},
    {"GL_TEXTURE3_EXT", GL_TEXTURE3_EXT},
    /* GL_SGIS_texture_edge_clamp */
    {"GL_CLAMP_TO_EDGE_SGIS", GL_CLAMP_TO_EDGE_SGIS},
#endif /*GLEXT*/
#ifdef GL12
        /* OpenGL 1.2 */
    {"GL_RESCALE_NORMAL", GL_RESCALE_NORMAL},
    {"GL_CLAMP_TO_EDGE", GL_CLAMP_TO_EDGE},
    {"GL_MAX_ELEMENTS_VERTICES", GL_MAX_ELEMENTS_VERTICES},
    {"GL_MAX_ELEMENTS_INDICES", GL_MAX_ELEMENTS_INDICES},
    {"GL_BGR", GL_BGR},
    {"GL_BGRA", GL_BGRA},
    {"GL_UNSIGNED_BYTE_3_3_2", GL_UNSIGNED_BYTE_3_3_2},
    {"GL_UNSIGNED_BYTE_2_3_3_REV", GL_UNSIGNED_BYTE_2_3_3_REV},
    {"GL_UNSIGNED_SHORT_5_6_5", GL_UNSIGNED_SHORT_5_6_5},
    {"GL_UNSIGNED_SHORT_5_6_5_REV", GL_UNSIGNED_SHORT_5_6_5_REV},
    {"GL_UNSIGNED_SHORT_4_4_4_4", GL_UNSIGNED_SHORT_4_4_4_4},
    {"GL_UNSIGNED_SHORT_4_4_4_4_REV", GL_UNSIGNED_SHORT_4_4_4_4_REV},
    {"GL_UNSIGNED_SHORT_5_5_5_1", GL_UNSIGNED_SHORT_5_5_5_1},
    {"GL_UNSIGNED_SHORT_1_5_5_5_REV", GL_UNSIGNED_SHORT_1_5_5_5_REV},
    {"GL_UNSIGNED_INT_8_8_8_8", GL_UNSIGNED_INT_8_8_8_8},
    {"GL_UNSIGNED_INT_8_8_8_8_REV", GL_UNSIGNED_INT_8_8_8_8_REV},
    {"GL_UNSIGNED_INT_10_10_10_2", GL_UNSIGNED_INT_10_10_10_2},
    {"GL_UNSIGNED_INT_2_10_10_10_REV", GL_UNSIGNED_INT_2_10_10_10_REV},
    {"GL_LIGHT_MODEL_COLOR_CONTROL", GL_LIGHT_MODEL_COLOR_CONTROL},
    {"GL_SINGLE_COLOR", GL_SINGLE_COLOR},
    {"GL_SEPARATE_SPECULAR_COLOR", GL_SEPARATE_SPECULAR_COLOR},
    {"GL_TEXTURE_MIN_LOD", GL_TEXTURE_MIN_LOD},
    {"GL_TEXTURE_MAX_LOD", GL_TEXTURE_MAX_LOD},
    {"GL_TEXTURE_BASE_LEVEL", GL_TEXTURE_BASE_LEVEL},
    {"GL_TEXTURE_MAX_LEVEL", GL_TEXTURE_MAX_LEVEL},
#endif /*GL12 */
    /* Bits */
    {"GL_CURRENT_BIT", GL_CURRENT_BIT},
    {"GL_POINT_BIT", GL_POINT_BIT},
    {"GL_LINE_BIT", GL_LINE_BIT},
    {"GL_POLYGON_BIT", GL_POLYGON_BIT},
    {"GL_POLYGON_STIPPLE_BIT", GL_POLYGON_STIPPLE_BIT},
    {"GL_PIXEL_MODE_BIT", GL_PIXEL_MODE_BIT},
    {"GL_LIGHTING_BIT", GL_LIGHTING_BIT},
    {"GL_FOG_BIT", GL_FOG_BIT},
    {"GL_DEPTH_BUFFER_BIT", GL_DEPTH_BUFFER_BIT},
    {"GL_ACCUM_BUFFER_BIT", GL_ACCUM_BUFFER_BIT},
    {"GL_STENCIL_BUFFER_BIT", GL_STENCIL_BUFFER_BIT},
    {"GL_VIEWPORT_BIT", GL_VIEWPORT_BIT},
    {"GL_TRANSFORM_BIT", GL_TRANSFORM_BIT},
    {"GL_ENABLE_BIT", GL_ENABLE_BIT},
    {"GL_COLOR_BUFFER_BIT", GL_COLOR_BUFFER_BIT},
    {"GL_HINT_BIT", GL_HINT_BIT},
    {"GL_EVAL_BIT", GL_EVAL_BIT},
    {"GL_LIST_BIT", GL_LIST_BIT},
    {"GL_TEXTURE_BIT", GL_TEXTURE_BIT},
    {"GL_SCISSOR_BIT", GL_SCISSOR_BIT},
    {"GL_ALL_ATTRIB_BITS", GL_ALL_ATTRIB_BITS},
    {"GL_CLIENT_PIXEL_STORE_BIT", GL_CLIENT_PIXEL_STORE_BIT},
    {"GL_CLIENT_VERTEX_ARRAY_BIT", GL_CLIENT_VERTEX_ARRAY_BIT},
    /*{"GL_CLIENT_ALL_ATTRIB_BITS", GL_CLIENT_ALL_ATTRIB_BITS}, */
    {NULL, 0}
};

static GLConst GLUCONSTS[] = {
    {"GLU_TRUE", GLU_TRUE},
    {"GLU_FALSE", GLU_FALSE},
    /* Normal vectors */
    {"GLU_SMOOTH", GLU_SMOOTH},
    {"GLU_FLAT", GLU_FLAT},
    {"GLU_NONE", GLU_NONE},
    /* Quadric draw styles */
    {"GLU_POINT", GLU_POINT},
    {"GLU_LINE", GLU_LINE},
    {"GLU_FILL", GLU_FILL},
    {"GLU_SILHOUETTE", GLU_SILHOUETTE},
    /* Quadric orientation */
    {"GLU_OUTSIDE", GLU_OUTSIDE},
    {"GLU_INSIDE", GLU_INSIDE},
    /* Tessellator */
    {"GLU_TESS_BEGIN", GLU_TESS_BEGIN},
    {"GLU_TESS_VERTEX", GLU_TESS_VERTEX},
    {"GLU_TESS_END", GLU_TESS_END},
    {"GLU_TESS_ERROR", GLU_TESS_ERROR},
    {"GLU_TESS_EDGE_FLAG", GLU_TESS_EDGE_FLAG},
    {"GLU_TESS_COMBINE", GLU_TESS_COMBINE},
    {"GLU_TESS_BEGIN_DATA", GLU_TESS_BEGIN_DATA},
    {"GLU_TESS_VERTEX_DATA", GLU_TESS_VERTEX_DATA},
    {"GLU_TESS_END_DATA", GLU_TESS_END_DATA},
    {"GLU_TESS_ERROR_DATA", GLU_TESS_ERROR_DATA},
    {"GLU_TESS_EDGE_FLAG_DATA", GLU_TESS_EDGE_FLAG_DATA},
    {"GLU_TESS_COMBINE_DATA", GLU_TESS_COMBINE_DATA},
    /* Winding rules */
    {"GLU_TESS_WINDING_ODD", GLU_TESS_WINDING_ODD},
    {"GLU_TESS_WINDING_NONZERO", GLU_TESS_WINDING_NONZERO},
    {"GLU_TESS_WINDING_POSITIVE", GLU_TESS_WINDING_POSITIVE},
    {"GLU_TESS_WINDING_NEGATIVE", GLU_TESS_WINDING_NEGATIVE},
    {"GLU_TESS_WINDING_ABS_GEQ_TWO", GLU_TESS_WINDING_ABS_GEQ_TWO},
    /* Tessellation properties */
    {"GLU_TESS_WINDING_RULE", GLU_TESS_WINDING_RULE},
    {"GLU_TESS_BOUNDARY_ONLY", GLU_TESS_BOUNDARY_ONLY},
    {"GLU_TESS_TOLERANCE", GLU_TESS_TOLERANCE},
    /* Tessellation errors */
    {"GLU_TESS_ERROR1", GLU_TESS_ERROR1},
    {"GLU_TESS_ERROR2", GLU_TESS_ERROR2},
    {"GLU_TESS_ERROR3", GLU_TESS_ERROR3},
    {"GLU_TESS_ERROR4", GLU_TESS_ERROR4},
    {"GLU_TESS_ERROR5", GLU_TESS_ERROR5},
    {"GLU_TESS_ERROR6", GLU_TESS_ERROR6},
    {"GLU_TESS_ERROR7", GLU_TESS_ERROR7},
    {"GLU_TESS_ERROR8", GLU_TESS_ERROR8},
    /* NURBS */
    {"GLU_AUTO_LOAD_MATRIX", GLU_AUTO_LOAD_MATRIX},
    {"GLU_CULLING", GLU_CULLING},
    {"GLU_PARAMETRIC_TOLERANCE", GLU_PARAMETRIC_TOLERANCE},
    {"GLU_SAMPLING_TOLERANCE", GLU_SAMPLING_TOLERANCE},
    {"GLU_DISPLAY_MODE", GLU_DISPLAY_MODE},
    {"GLU_SAMPLING_METHOD", GLU_SAMPLING_METHOD},
    {"GLU_U_STEP", GLU_U_STEP},
    {"GLU_V_STEP", GLU_V_STEP},
    {"GLU_PATH_LENGTH", GLU_PATH_LENGTH},
    {"GLU_PARAMETRIC_ERROR", GLU_PARAMETRIC_ERROR},
    {"GLU_DOMAIN_DISTANCE", GLU_DOMAIN_DISTANCE},
    {"GLU_MAP1_TRIM_2", GLU_MAP1_TRIM_2},
    {"GLU_MAP1_TRIM_3", GLU_MAP1_TRIM_3},
    {"GLU_OUTLINE_POLYGON", GLU_OUTLINE_POLYGON},
    {"GLU_OUTLINE_PATCH", GLU_OUTLINE_PATCH},
    {"GLU_NURBS_ERROR1", GLU_NURBS_ERROR1},
    {"GLU_NURBS_ERROR2", GLU_NURBS_ERROR2},
    {"GLU_NURBS_ERROR3", GLU_NURBS_ERROR3},
    {"GLU_NURBS_ERROR4", GLU_NURBS_ERROR4},
    {"GLU_NURBS_ERROR5", GLU_NURBS_ERROR5},
    {"GLU_NURBS_ERROR6", GLU_NURBS_ERROR6},
    {"GLU_NURBS_ERROR7", GLU_NURBS_ERROR7},
    {"GLU_NURBS_ERROR8", GLU_NURBS_ERROR8},
    {"GLU_NURBS_ERROR9", GLU_NURBS_ERROR9},
    {"GLU_NURBS_ERROR10", GLU_NURBS_ERROR10},
    {"GLU_NURBS_ERROR11", GLU_NURBS_ERROR11},
    {"GLU_NURBS_ERROR12", GLU_NURBS_ERROR12},
    {"GLU_NURBS_ERROR13", GLU_NURBS_ERROR13},
    {"GLU_NURBS_ERROR14", GLU_NURBS_ERROR14},
    {"GLU_NURBS_ERROR15", GLU_NURBS_ERROR15},
    {"GLU_NURBS_ERROR16", GLU_NURBS_ERROR16},
    {"GLU_NURBS_ERROR17", GLU_NURBS_ERROR17},
    {"GLU_NURBS_ERROR18", GLU_NURBS_ERROR18},
    {"GLU_NURBS_ERROR19", GLU_NURBS_ERROR19},
    {"GLU_NURBS_ERROR20", GLU_NURBS_ERROR20},
    {"GLU_NURBS_ERROR21", GLU_NURBS_ERROR21},
    {"GLU_NURBS_ERROR22", GLU_NURBS_ERROR22},
    {"GLU_NURBS_ERROR23", GLU_NURBS_ERROR23},
    {"GLU_NURBS_ERROR24", GLU_NURBS_ERROR24},
    {"GLU_NURBS_ERROR25", GLU_NURBS_ERROR25},
    {"GLU_NURBS_ERROR26", GLU_NURBS_ERROR26},
    {"GLU_NURBS_ERROR27", GLU_NURBS_ERROR27},
    {"GLU_NURBS_ERROR28", GLU_NURBS_ERROR28},
    {"GLU_NURBS_ERROR29", GLU_NURBS_ERROR29},
    {"GLU_NURBS_ERROR30", GLU_NURBS_ERROR30},
    {"GLU_NURBS_ERROR31", GLU_NURBS_ERROR31},
    {"GLU_NURBS_ERROR32", GLU_NURBS_ERROR32},
    {"GLU_NURBS_ERROR33", GLU_NURBS_ERROR33},
    {"GLU_NURBS_ERROR34", GLU_NURBS_ERROR34},
    {"GLU_NURBS_ERROR35", GLU_NURBS_ERROR35},
    {"GLU_NURBS_ERROR36", GLU_NURBS_ERROR36},
    {"GLU_NURBS_ERROR37", GLU_NURBS_ERROR37},
#ifdef GL13
    /* GLU 1.3 and later */
    /* Errors */
    {"GLU_INVALID_ENUM", GLU_INVALID_ENUM},
    {"GLU_INVALID_VALUE", GLU_INVALID_VALUE},
    {"GLU_OUT_OF_MEMORY", GLU_OUT_OF_MEMORY},
    {"GLU_INCOMPATIBLE_GL_VERSION", GLU_INCOMPATIBLE_GL_VERSION},
#endif /*GL13*/
    /* GLU 1.1 and later */
    {"GLU_VERSION", GLU_VERSION},
    {"GLU_EXTENSIONS", GLU_EXTENSIONS},
  /*** GLU 1.0 tessellation - obsolete! ***/
    /* Contour types */
    {"GLU_CW", GLU_CW},
    {"GLU_CCW", GLU_CCW},
    {"GLU_INTERIOR", GLU_INTERIOR},
    {"GLU_EXTERIOR", GLU_EXTERIOR},
    {"GLU_UNKNOWN", GLU_UNKNOWN},
    /* Tessellator */
    {"GLU_BEGIN", GLU_TESS_BEGIN},
    {"GLU_VERTEX", GLU_TESS_VERTEX},
    {"GLU_END", GLU_TESS_END},
    {"GLU_ERROR", GLU_TESS_ERROR},
    {"GLU_EDGE_FLAG", GLU_TESS_EDGE_FLAG},
    {NULL, 0}
};

int Tom_GLDataInit(Tcl_Interp *interp) {
    GLConst *gl;
    char name[64], value[32];

    for (gl = GLCONSTS; gl->name != NULL; gl++) {
        strcpy(name, "::GL::");
        strcat(name, gl->name);
        sprintf(value, "%d", gl->value);
        if (Tcl_SetVar(interp, name, value, TCL_LEAVE_ERR_MSG) == NULL) return TCL_ERROR;
    }

    for (gl = GLUCONSTS; gl->name != NULL; gl++) {
        strcpy(name, "::GL::");
        strcat(name, gl->name);
        sprintf(value, "%d", gl->value);
        if (Tcl_SetVar(interp, name, value, TCL_LEAVE_ERR_MSG) == NULL) return TCL_ERROR;
    }

    return TCL_OK;
}

int Tom_GetTypeSize(GLenum type) {
    switch (type) {
    case GL_FLOAT:
        return sizeof (GLfloat);
    case GL_UNSIGNED_BYTE:
    case GL_BYTE:
    case GL_BITMAP:
        return sizeof (GLbyte);
    case GL_UNSIGNED_SHORT:
    case GL_SHORT:
        return sizeof (GLshort);
    case GL_UNSIGNED_INT:
    case GL_INT:
        return sizeof (GLint);
    case GL_DOUBLE:
        return sizeof (GLdouble);
    case GL_2_BYTES:
        return (2 * sizeof (GLbyte));
    case GL_3_BYTES:
        return (3 * sizeof (GLbyte));
    case GL_4_BYTES:
        return (4 * sizeof (GLbyte));
    default:
        return 0;
    }
}

int Tom_GetFormatSize(GLenum format) {
    switch (format) {
    case GL_ALPHA:
    case GL_DEPTH_COMPONENT:
    case GL_LUMINANCE:
    case GL_RED:
    case GL_GREEN:
    case GL_BLUE:
    case GL_COLOR_INDEX:
        return 1;
    case GL_RGB:
        return 3;
    case GL_RGBA:
        return 4;
    case GL_LUMINANCE_ALPHA:
        return 2;
    default:
        return 0;
    }
}
