[comment {-*- tcl -*- doctools manpage}]
[manpage_begin mime n 1.3.6]
[copyright {1999-2000 Marshall T. Rose}]
[moddesc   {Mime}]
[titledesc {Manipulation of MIME body parts}]
[require Tcl]
[require mime [opt 1.3.6]]
[description]
[para]

The [package mime] library package provides the commands to create and
manipulate MIME body parts.

[list_begin definitions]


[call [cmd ::mime::initialize] [opt "[option -canonical] [arg type/subtype] [opt "[option -param] \{[arg {key value}]\}..."] [opt "[option -encoding] [arg value]"] [opt "[option -header] \{[arg {key value}]\}..."]"] "([option -file] [arg name] | [option -string] [arg value] | [option -part] \{[arg token1] ... [arg tokenN]\})"]

This command creates a MIME part and returns a token representing it.

[list_begin bullet]

[bullet]

If the [option -canonical] option is present, then the body is in
canonical (raw) form and is found by consulting either the

[option -file], [option -string], or [option -part] option.

[nl]

In addition, both the [option -param] and [option -header] options may
occur zero or more times to specify [const Content-Type] parameters
(e.g., [const charset]) and header keyword/values (e.g.,

[const Content-Disposition]), respectively.

[nl]

Also, [option -encoding], if present, specifies the

[const Content-Transfer-Encoding] when copying the body.

[bullet]

If the [option -canonical] option is not present, then the MIME part
contained in either the [option -file] or the [option -string] option
is parsed, dynamically generating subordinates as appropriate.

[list_end]


[call [cmd ::mime::finalize] [arg token] [opt "[option -subordinates] [const all] | [const dynamic] | [const none]"]]

This command destroys the MIME part represented by [arg token]. It
returns an empty string.

[nl]

If the [option -subordinates] option is present, it specifies which
subordinates should also be destroyed. The default value is

[const dynamic], destroying all subordinates which were created by
[cmd ::mime::initialize] together with the containing body part.


[call [cmd ::mime::getproperty] [arg token] [opt "[arg property] | [option -names]"]]

This command returns a string or a list of strings containing the
properties of a MIME part. If the command is invoked with the name of
a specific property, then the corresponding value is returned;
instead, if [option -names] is specified, a list of all properties is
returned; otherwise, a serialized array of properties and values is
returned.

[nl]
The possible properties are:

[list_begin definitions]


[lst_item [const content]]

The type/subtype describing the content

[lst_item [const encoding]]

The "Content-Transfer-Encoding"

[lst_item [const params]]

A list of "Content-Type" parameters

[lst_item [const parts]]

A list of tokens for the part's subordinates.  This property is
present only if the MIME part has subordinates.

[lst_item [const size]]

The approximate size of the content (unencoded)

[list_end]


[call [cmd ::mime::getheader] [arg token] [opt "[arg key] | [option -names]"]]

This command returns the header of a MIME part, as a list of strings.

[nl]

A header consists of zero or more key/value pairs. Each value is a
list containing one or more strings.

[nl]

If this command is invoked with the name of a specific [arg key], then
a list containing the corresponding value(s) is returned; instead, if
-names is specified, a list of all keys is returned; otherwise, a
serialized array of keys and values is returned. Note that when a key
is specified (e.g., "Subject"), the list returned usually contains
exactly one string; however, some keys (e.g., "Received") often occur
more than once in the header, accordingly the list returned usually
contains more than one string.


[call [cmd ::mime::setheader] [arg token] [arg {key value}] [opt "[option -mode] [const write] | [const append] | [const delete]"]]

This command writes, appends to, or deletes the [arg value] associated
with a [arg key] in the header. It returns a list of strings
containing the previous value associated with the key.

[nl]

The value for [option -mode] is one of:

[list_begin definitions]


[lst_item [const write]]

The [arg key]/[arg value] is either created or overwritten (the default).

[lst_item [const append]]

A new [arg value] is appended for the [arg key] (creating it as necessary).

[lst_item [const delete]]

All values associated with the key are removed (the [arg value]
parameter is ignored).

[list_end]


[call [cmd ::mime::getbody] [arg token] [opt "[option -command] [arg callback] [opt "[option -blocksize] [arg octets]"]"]]

This command returns a string containing the body of the leaf MIME
part represented by [arg token] in canonical form.

[nl]

If the [option -command] option is present, then it is repeatedly
invoked with a fragment of the body as this:

[example {
  uplevel #0 $callback [list "data" $fragment]
}]

[nl]

(The [option -blocksize] option, if present, specifies the maximum
size of each fragment passed to the callback.)

[nl]

When the end of the body is reached, the callback is invoked as:

[example {
    uplevel #0 $callback "end"
}]

[nl]

Alternatively, if an error occurs, the callback is invoked as:

[example {
    uplevel #0 $callback [list "error" reason]
}]

[nl]

Regardless, the return value of the final invocation of the callback
is propagated upwards by [cmd ::mime::getbody].

[nl]

If the [option -command] option is absent, then the return value of
[cmd ::mime::getbody] is a string containing the MIME part's entire
body.


[call [cmd ::mime::copymessage] [arg token] [arg channel]]

This command copies the MIME represented by [arg token] part to the
specified [arg channel]. The command operates synchronously, and uses
fileevent to allow asynchronous operations to proceed
independently. It returns an empty string.


[call [cmd ::mime::buildmessage] [arg token]]

This command returns the MIME part represented by [arg token] as a
string.  It is similar to [cmd ::mime::copymessage], only it returns
the data as a return string instead of writing to a channel.


[call [cmd ::mime::parseaddress] [arg string]]

This command takes a string containing one or more 822-style address
specifications and returns a list of serialized arrays, one element
for each address specified in the argument. If the string contains
more than one address they will be separated by commas.

[nl]

Each serialized array contains the properties below. Note that one or
more of these properties may be empty.

[list_begin definitions]


[lst_item [const address]]

local@domain

[lst_item [const comment]]

822-style comment

[lst_item [const domain]]

the domain part (rhs)

[lst_item [const error]]

non-empty on a parse error

[lst_item [const group]]

this address begins a group

[lst_item [const friendly]]

user-friendly rendering

[lst_item [const local]]

the local part (lhs)

[lst_item [const memberP]]

this address belongs to a group

[lst_item [const phrase]]

the phrase part

[lst_item [const proper]]

822-style address specification

[lst_item [const route]]

822-style route specification (obsolete)

[list_end]


[call [cmd ::mime::parsedatetime] ([arg string] | [option -now]) [arg property]]

This command takes a string containing an 822-style date-time
specification and returns the specified property as a serialized
array.

[nl]

The list of properties and their ranges are:

[list_begin definitions]


[lst_item [const hour]]

0 .. 23

[lst_item [const lmonth]]

January, February, ..., December

[lst_item [const lweekday]]

Sunday, Monday, ... Saturday

[lst_item [const mday]]

1 .. 31

[lst_item [const min]]

0 .. 59

[lst_item [const mon]]

1 .. 12

[lst_item [const month]]

Jan, Feb, ..., Dec

[lst_item [const proper]]

822-style date-time specification

[lst_item [const rclock]]

elapsed seconds between then and now

[lst_item [const sec]]

0 .. 59

[lst_item [const wday]]

0 .. 6 (Sun .. Mon)

[lst_item [const weekday]]

Sun, Mon, ..., Sat

[lst_item [const yday]]

1 .. 366

[lst_item [const year]]

1900 ...

[lst_item [const zone]]

-720 .. 720 (minutes east of GMT)

[list_end]


[call [cmd ::mime::mapencoding] [arg encoding_name]]

This commansd maps tcl encodings onto the proper names for their MIME
charset type.  This is only done for encodings whose charset types
were known.  The remaining encodings return "" for now.


[call [cmd ::mime::reversemapencoding] [arg charset_type]]

This command maps MIME charset types onto tcl encoding names.  Those
that are unknown return "".


[list_end]


[section {KNOWN BUGS}]

[list_begin definitions]
[lst_item {SourceForge Tcllib Bug #447037}]

This problem affects only people which are using Tcl and Mime on a
64-bit system. The currently recommended fix for this problem is to
upgrade to Tcl version 8.4. This version has extended 64 bit support
and the bug does not appear anymore.

[nl]

The problem could have been generally solved by requiring the use of
Tcl 8.4 for this package. We decided against this solution as it would
force a large number of unaffected users to upgrade their Tcl
interpreter for no reason.

[nl]

See [uri http://sourceforge.net/tracker/?func=detail&aid=447037&group_id=12883&atid=112883]
for additional information.

[list_end]



[see_also smtp pop3 ftp http]
[keywords mail email smtp mime {rfc 821} {rfc 822} internet net]
[manpage_end]
