/*
 * Simplified glob matching - supports * ? and []
 *
 * Copyright (C) 2002, Olaf Kirch <okir@lst.de>
 */

#include <string.h>
#include "resmgr.h"

int
rsm_glob(const char *pattern, const char *name, const char *end)
{
	if (pattern == NULL)
		return 1;

	if (name == NULL)
		return 0;

	if (end == NULL)
		end = name + strlen(name);

	while (*pattern) {
		unsigned char	pc = *pattern++, nc;
		int		match = 0;

		if (pc == '*') {
			if (*pattern == '\0')
				return 1;
			while (name < end) {
				if (rsm_glob(pattern, name, end))
					return 1;
				name++;
			}
			return 0;
		}

		if (name >= end)
			return 0;
		nc = *name++;

		if (pc == '[') {
			unsigned char	lo, hi;

			while (1) {
				if (!(lo = *pattern++))
					return 0;
				if (lo == ']')
					break;

				if (*pattern == '-') {
					pattern++;
					if (!(hi = *pattern++))
						return 0;
				} else {
					hi = lo;
				}

				while (lo <= hi)
					match |= (nc == lo++);
			}
		} else {
			match = (pc == '?' || pc == nc);
		}
		if (!match)
			return 0;
	}

	return (name == end);
}
