/************************************************************************
  			specificrepository.h - Copyright Johannes Nicolai <johannes_nicolai@tiscalinet.de>

This file was generated on Sa Apr 10 2004 at 17:48:46
    
    RTB - Team Framework: Framework for RealTime Battle robots to communicate efficiently in a team
    Copyright (C) 2004 The RTB- Team Framework Group: http://rtb-team.sourceforge.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


The original location of this file is strategies
**************************************************************************/

#ifndef SPECIFICREPOSITORY_H
#define SPECIFICREPOSITORY_H

#include "../exceptions/strategyexception.h"
#include <stdexcept>

/**
 * Namespace Strategies
 */
namespace Strategies {
	using std::bad_exception;
	using Exceptions::StrategyException;
	
	
	/**
	* Class SpecificRepository
	*
	* SpecificRepository is the base class of all robot specific repositories.
	* In a repository, every strategy can store individual data. 
	* The only common method is the ability to reset the repository
	*/ 
	class SpecificRepository {
	/*
	* Public stuff
	*/
	public:
		/**
		* Method to reset the repositories
		*/
		virtual void reset() throw(StrategyException, bad_exception)=0;
		
		
		/**
		* Destructor (does nothing, only assures that instances of concrete subclasses will be deleted properly by their coordinator
		*/
		virtual ~SpecificRepository () {};	
	};
}

#endif
