#include "allegro.h"
#include "spaceobj.h"
#include "hull_weapon.h"
#include "hull_weapon_rocket_normal.h"

NormalRocket_WHull::NormalRocket_WHull():
HullWeapon( 0, 1, 20 ){}

void NormalRocket_WHull::Draw( BITMAP * who, int x, int y ) {
	#define Xfactor 4
	#define Yfactor 20
	rectfill( who, x, y+3, x+Xfactor, y+Yfactor, makecol(200,200,200) );
	triangle( who, x, y+3, x+Xfactor/2, y, x+Xfactor, y+3, makecol(230,230,230) );
}


bool NormalRocket_WHull::Collide( int mx, int my, SpaceObject * check ) {
	if ( check->HitMe( mx, my ) )
		return true;
	if ( check->HitMe( mx+Xfactor/2, my+Yfactor*2/3 ) )
		return true;
	return false;
}
