/*
 * QCameraKeyPathDropSite.cpp
 * $Id: 
 *
 * Copyright (C) 2001 Alexander Buck, Thomas Woerner, Markus Janich
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * As a special exception to the GPL, the QGLViewer authors (Markus
 * Janich, Michael Meissner, Richard Guenther, Alexander Buck and Thomas
 * Woerner) give permission to link this program with Qt (non-)commercial
 * edition, and distribute the resulting executable, without including
 * the source code for the Qt (non-)commercial edition in the source
 * distribution.
 *
 */

// Qt
///////
#include <qevent.h>
#include <qpixmap.h>
#include <qdragobject.h>


// System
///////////


// Own
///////////
#include "QCameraKeyPathDropSite.h"
#include "QCameraKeyPathDrag.h"
#include "pictures/dragkeycamerapath.xpm"




// Function  : QCameraKeyPathDropSite
// Parameters: CCamera *pCamera, QWidget *parent, const char *sName
// Purpose   : default constructor.
// Comments  : See docu for details.
QCameraKeyPathDropSite::QCameraKeyPathDropSite(QWidget *parent,
					       const char *sName)
                       : QLabel(parent, sName)
//,
//      clist(NULL)
/*********************************************************************/
{
   QPixmap dragCameraPix((const char **) dragkeycamerapath_xpm);

   if (!(dragCameraPix.isNull()))
      setPixmap(dragCameraPix);
   else
      setText("Drag and Drop");
   setAlignment(Qt::AlignCenter);
    
   setFrameStyle(QFrame::Raised + QFrame::WinPanel);
   setAcceptDrops(TRUE);
}



// Function  : dragEnterEvent
// Parameters: QDragEnterEvent *pqEvent
// Purpose   : handles QDragEnterEvents.
// Comments  : See docu for details.
void QCameraKeyPathDropSite::dragEnterEvent(QDragEnterEvent *pqEvent)
/*********************************************************************/
{
   if (!isEnabled())
     return;

   if (QCameraKeyPathDrag::canDecode(pqEvent)) {
      pqEvent->accept();
      setFrameStyle(QFrame::Sunken + QFrame::WinPanel);  
   }
}



// Function  : dragLeaveEvent
// Parameters: QDragLeaveEvent *pqEvent
// Purpose   : handles QDragLeaveEvents.
// Comments  : See docu for details.
void QCameraKeyPathDropSite::dragLeaveEvent(QDragLeaveEvent *)
/*********************************************************************/
{
   setFrameStyle(QFrame::Raised + QFrame::WinPanel);
}



// Function  : dropEvent
// Parameters: QDropEvent *pqEvent
// Purpose   : handles QDropEvents.
// Comments  : See docu for details.
void QCameraKeyPathDropSite::dropEvent(QDropEvent *pqEvent)
/*********************************************************************/
{
   CList<CCameraKeyPathPoint> list;

   if (pqEvent->source() != this)
      if (QCameraKeyPathDrag::decode(pqEvent, list))
         emit(sigCameraKeyPathDropped(list));

   setFrameStyle(QFrame::Raised + QFrame::WinPanel);
}



// Function  : mousePressEvent
// Parameters: QMouseEvent *pqEvent
// Purpose   : handles mouse press events.
// Comments  : See docu for details.
void QCameraKeyPathDropSite::mousePressEvent(QMouseEvent *)
/*********************************************************************/
{
   QDragObject *pqDragObject;

   if (m_pCList->getNumObjects() > 0) {
      setFrameStyle(QFrame::Sunken + QFrame::WinPanel);  
      pqDragObject = new QCameraKeyPathDrag(*m_pCList, this);
      pqDragObject->setPixmap(QPixmap((const char **) dragkeycamerapath_xpm),
                              QPoint(13, 10));
      pqDragObject->dragCopy();
   }
}



// Function  : mouseReleaseEvent
// Parameters: QMouseEvent *pqEvent
// Purpose   : handles mouse release events.
// Comments  : See docu for details.
void QCameraKeyPathDropSite::mouseReleaseEvent(QMouseEvent *)
/*********************************************************************/
{
   setFrameStyle(QFrame::Raised + QFrame::WinPanel);
}
