#
#	Test client base implementation, used by each of the tests
#

import sys
import Pyro.naming, Pyro.core, Pyro.protocol

group = ':test'  # the default namespace group for the tests

# moduleName = the name of the module (if any) which contains the static
#              proxy (generated by pyroc)
# className = the classname of the Pyro implementation class in the
#             module mentioned above
# objname = the name of the object which is used in the NS
# withAttrs = use a DynamicProxyWithAttrs or a regular DynamicProxy?
#
# Eventually, this function will return a proxy object that can be used.
def start(moduleName, className, objName, withAttrs=0):
	# try to load the static proxy code
	if moduleName:
		try:
			prox = __import__(moduleName,locals(),globals())
			print '*** Using static proxy.'
			dynproxy = 0
		except ImportError:
			print '*** WARNING: no proxy module found. Using dynamic proxy.'
			dynproxy = 1
	else:
		dynproxy = 1

	# initialize the client and set the default namespace group
	Pyro.core.initClient()
	Pyro.config.PYRO_NS_DEFAULTGROUP=group


	# locate the NS
	locator = Pyro.naming.NameServerLocator()
	print 'Searching Naming Service...',
	ns = locator.getNS()
	print 'Naming Service found at',ns.URI.address,'('+(Pyro.protocol.getHostname(ns.URI.address) or '??')+') port',ns.URI.port

	# resolve the Pyro object
	print 'binding to object'
	try:
		URI=ns.resolve(objName)
		print 'URI:',URI
	except Pyro.core.PyroError,x:
		print 'Couldn\'t bind object, nameserver says:',x
		raise SystemExit

	# create a proxy for the Pyro object, and return that
	if dynproxy:
		# use dynamic proxy
		if withAttrs:
			obj = Pyro.core.getAttrProxyForURI(URI)
		else:
			obj = Pyro.core.getProxyForURI(URI)
	else:
		# use static (precompiled) proxy
		obj = getattr(prox,className)(URI)

	return obj

