# prime/engine/engine.rb
# $Id: engine.rb,v 1.3 2004/03/25 17:19:50 komatsu Exp $
#
# Copyright (C) 2002 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.
#

$engine_class_name = 'PrimeEngine'

require 'prime/taiyaki'

class PrimeEngine
  include Debug
  attr_reader :name, :id, :description, :status

  def initialize
    @debug_mode = false
    
    @name = "vanilla engine"
    @id   = "vanilla"
    @description = "skeleton engine"
  end

  def get_pos_data (string)
    #| get_pos_data(string)
    #| => {'pron1' => ['pos1-1', 'pos1-2',...], 'pron2' => ... }
    pos_data = {}
    return pos_data
  end

  def search (query)
    return PrimeWordList.new()
  end

  def check_existence (pron, literal, pos)
    return false
  end

  def learn_word (key, value, part = nil,
		  context = nil, suffix = nil, rest = nil)
    # return true if word was learned, or return false.
    return false 
  end

  ## init
  # initialize this engine.  init should be called only once first.
  def init
    return true # or false
  end

  ## exit
  # finalize this engine.  exit should be called only once last.
  def exit
    return true # or false
  end

  ## open
  # open a connection with this engine.
  def open
    return true # or false
  end

  ## close
  # close the connection with this engine.
  def close
    return true # of false
  end

  ## update
  # update the data of the conversion engines.
  def update
    return true
  end
  ## refresh
  # refresh the statuses of the conversion engines.
  # this is supporsed to be called after update.
  def refresh
    return true
  end
end
