///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "webbrowser.h"
#include "widget/usererror.h"
#include "defines.h" // VERSION
#include "util/filesys.h"
#include <glibmm/spawn.h>

namespace {
  const std::string browser = "gnome-moz-remote";
}

const std::string homepage = "http://www.stacken.kth.se/project/pptout/";

void open_url(const std::string &url) {
  try {
    Glib::spawn_command_line_async(browser + " \"" + url + "\"");
    
  } catch(const Glib::SpawnError& e) {
    throw UserError("Failed to run web browser \"" + browser + '"', e.what());
  }
}

void open_homepage() {open_url(homepage);}

void open_docs() {
  std::string url = DOCDIR "/users_guide.html";
  if(access(url))
    url = "file://" + url;
  else
    url = "http://www.stacken.kth.se/project/pptout/doc/" 
      + std::string(VERSION)
      + "/users_guide.html";
  open_url(url);
}
