.\"
.\" %nmhwarning%
.\" $Id: inc.man,v 1.13 2001/01/25 21:15:54 ssen Exp $
.\"
.TH INC %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
inc \- incorporate new mail
.SH SYNOPSIS
.HP 5
.na
.B inc
.RI [ +folder ]
.RB [ \-audit
.IR audit\-file ]
.RB [ \-noaudit ]
.RB [ \-changecur " | " \-nochangecur ]
.RB [ \-form
.IR formfile ]
.RB [ \-format
.IR string ]
.RB [ \-file
.IR name ]
.RB [ \-silent " | " \-nosilent ]
.RB [ \-truncate " | " \-notruncate ]
.RB [ \-width
.IR columns ]
%nmhbeginpop%
.RB [ \-host
.IR hostname ]
.RB [ \-user
.IR username ]
.RB [ \-pack
.IR file ]
.RB [ \-nopack ]
.RB [ \-apop " | " \-noapop ]
.RB [ \-kpop ]
.RB [ \-sasl ]
.RB [ \-saslmech
.IR mechanism ]
.RB [ \-snoop ]
%nmhendpop%
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Inc
incorporates mail from the user's incoming mail drop into
an
.B nmh
folder.
.PP
You may specify which folder to use with
.IR +folder .
If no folder is specified, then
.B inc
will use either the folder given by a (non\-empty)
.RI \*(lq Inbox \*(rq
entry in the user's profile, or the folder named
.RI \*(lq inbox \*(rq.
If the specified (or default) folder doesn't
exist, the user will be queried prior to its creation.
.PP
When the new messages are incorporated into the folder, they are assigned
numbers starting with the next highest number for the folder.  As the
messages are processed, a
.B scan
listing of the new mail is produced.
.PP
If the user's profile contains a
.RI \*(lq "Msg\-Protect: nnn" \*(rq
entry, it
will be used as the protection on the newly created messages, otherwise
the
.B nmh
default of 0644 will be used.  For all subsequent operations
on these messages, this initially assigned protection will be preserved.
.PP
If the switch
.B \-audit
.I audit\-file
is specified (usually as a default
switch in the profile), then
.B inc
will append a header line and a
line per message to the end of the specified audit\-file with the format:
.PP
.RS 5
.nf
\*(<<inc\*(>> date
<scan line for first message>
<scan line for second message>
<etc.>
.fi
.RE
.PP
This is useful for keeping track of volume and source of incoming mail.
Eventually,
.BR repl ,
.BR forw ,
.BR comp ,
and
.B dist
may also produce audits to this (or another) file, perhaps with
.RI \*(lq Message\-Id \*(rq
information to keep an exact correspondence
history.
.RI \*(lq Audit\-file \*(rq
will be in the user's nmh directory unless a full path is specified.
.PP
.B Inc
will incorporate even improperly formatted messages into the
user's nmh folder, inserting a blank line prior to the offending component
and printing a comment identifying the bad message.
.PP
In all cases, the user's mail drop will be zeroed, unless the
.B \-notruncate
switch is given.
.PP
If the profile entry
.RI \*(lq Unseen\-Sequence \*(rq
is present and non\-empty, then
.B inc
will add each of the newly incorporated messages to
each sequence named by the profile entry.
.B Inc
will not zero each sequence prior to adding messages.
.PP
The interpretation of the
.B \-form
.IR formatfile ,
.B \-format
.IR string ,
and
.B \-width
.I columns
switches is the same as in
.BR scan .
.PP
By using the
.B \-file
.I name
switch, one can direct
.B inc
to incorporate messages from a file other than the user's maildrop.
Note that the name file will NOT be zeroed, unless the
.B \-truncate
switch is given.
.PP
If the environment variable
.B $MAILDROP
is set, then
.B inc
uses it as the location of the user's maildrop instead of the default
(the
.B -file
.I name
switch still overrides this, however).  If this
environment variable is not set, then
.B inc
will consult the profile entry
.RI \*(lq MailDrop \*(rq
for this information.  If the value found is
not absolute, then it is interpreted relative to the user's
.B nmh
directory.  If the value is not found, then
.B inc
will look in the standard system location for the user's maildrop.
.PP
The
.B \-silent
switch directs
.B inc
to be quiet and not ask any questions at all.  This is useful for putting
.B inc
in the background and going on to other things.
%nmhbeginpop%
.PP
.SS "Using POP"
.B inc
will normally check local mail drops for mail, as covered above.  But
if the option
.RI \*(lq pophost \*(rq
is set in
.RI \*(lq mts.conf \*(rq,
or if the
.B \-host
.I hostname
switch is given, or if the
.B $MAILHOST
environment variable is set, then
.B inc
will query this POP service host for mail to incorporate.  If
.B $MAILHOST
is set and
.B \-host
is specified as well, the commandline switch will override
the environment variable.
.PP
The default is for
.B inc
to assume that your account name on
the POP server is the same as your current username.  To specify
a different username, use the
.B \-user
.I username
switch.
.PP
When using POP, you will normally need to type the password for
your account on the POP server, in order to retrieve your messages.
It is possible to automate this process by creating a
.RI \*(lq .netrc \*(rq
file containing your login account information for this POP server.
For each POP server, this file should have a line of the following
form.  Replace the words
.IR mypopserver ,
.IR mylogin ,
and
.I mypassword
with your own account information.
.PP
.RS 5
.B machine
.I mypopserver
.B login
.I mylogin
.B password
.I mypassword
.RE
.PP
This
.RI \*(lq .netrc \*(rq
file should be owned and readable only by you.
.PP
If
.B inc
uses POP, then the
.B \-pack
.I file
switch is considered. If given, then
.B inc
simply uses the POP to
.B packf
the user's maildrop from the POP service host to the named file.  This switch
is provided for those users who prefer to use
.B msh
to read their maildrops.
.PP
For debugging purposes, you may give the switch
.BR \-snoop ,
which will allow you to watch the POP transaction take place
between you and the POP server.
.PP
If
.B nmh
has been compiled with APOP support, the
.B \-apop
switch will cause
.B inc
to use APOP rather than standard POP3 authentication.  Under APOP, a
unique string (generally of the format
.RI < pid . timestamp @ hostname >
) is announced by the POP server.
Rather than `USER
.IR user ',
`PASS
.IR password ',
.B inc
sends `APOP
.I user
.IR digest ',
where digest is the MD5 hash of the unique string followed by a
`secret' shared by client and server, essentially equivalent to the user's
password (though an APOP-enabled POP3 server could have separate APOP and plain
POP3 passwords for a single user).
.B \-noapop
disables APOP in cases where it'd otherwise be used.
.PP
If
.B nmh
has been compiled with KPOP support, the
.B \-kpop
switch will allow
.B inc
to use Kerberized POP rather than standard POP3 on a given invocation.
If POPSERVICE was also #defined to "kpop",
.B inc
will be hardwired to always use KPOP.
.PP
If
.B nmh
has been compiled with SASL support, the
.B \-sasl
switch will enable
the use of SASL authentication.  Depending on the SASL mechanism used, this
may require an additional password prompt from the user (but the
.RI \*(lq .netrc \*(rq
file can be used to store this password).  The
.B \-saslmech
switch can be used to select a particular SASL mechanism.
.PP
If SASL authentication is successful,
.B inc
will attempt to negotiate a security layer for session encryption.
Encrypted traffic is labelled with `(encrypted)' and `(decrypted)'
when viewing the POP transaction with the
.B \-snoop
switch.
%nmhendpop%

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^%etcdir%/mts.conf~^nmh mts configuration file
^%mailspool%/$USER~^Location of mail drop
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Alternate\-Mailboxes:~^To determine the user's mailboxes
^Inbox:~^To determine the inbox, default \*(lqinbox\*(rq
^Folder\-Protect:~^To set mode when creating a new folder
^Msg\-Protect:~^To set mode when creating a new message and audit\-file
^Unseen\-Sequence:~^To name sequences denoting unseen messages
.fi

.SH "SEE ALSO"
mhmail(1), scan(1), mh\-mail(5), post(8)

.SH DEFAULTS
.nf
.RB ` +folder "' defaulted by \*(lqInbox\*(rq above"
.RB ` \-noaudit '
.RB ` \-changecur '
.RB ` \-format "' defaulted as described above"
.RB ` \-nosilent '
.RB ` \-truncate "' if `" \-file " name' not given, `" \-notruncate "' otherwise"
.RB ` \-width "' defaulted to the width of the terminal"
%nmhbeginpop%
.RB ` \-nopack '
%nmhendpop%
.fi

.SH CONTEXT
The folder into which messages are being incorporated will become the
current folder.  The first message incorporated will become the current
message, unless the
.B \-nochangecur
option is specified.  This leaves the context ready for a
.B show
of the first new message.

.SH BUGS
The argument to the
.B \-format
switch must be interpreted as a single
token by the shell that invokes
.BR inc .
Therefore, one must usually place the argument to this switch inside
double\-quotes.
