#define WAIT_FOR_FILE_DELAY	250	/* sleep when waiting for a file to become available */
#define MAX_N_RE_MATCHES	16	/* max. number of regex matches: used for coloring matches */
#define MIN_N_BUFFERLINES	100	/* number of lines to buffer at minimum */
#define MAX_N_SPAWNED_PROCESSES	16	/* max. nr. of processes executed by matching regexps */

#define TERM_MISC	0
#define TERM_XTERM	1

#ifndef _BSD_SOURCE
#define _BSD_SOURCE	/* don't worry: it'll still work if you don't have
			 * a BSD system
			 */
#endif
#ifndef __USE_BSD
#define __USE_BSD	/* manpage says _BSD_SOURCE, stdlib.h says __USE_BSD */
#endif

#if defined(__FreeBSD__) || defined(linux) || defined(__OpenBSD__) || defined(__NetBSD__) || defined(__APPLE__) || defined(sun)
#include <ncurses.h>
#define N_CURSES
#else
#include <curses.h>
#endif

/* Tru64 workaround */
#if defined(OSF1)
	#undef getmaxyx
	#define getmaxyx(w,y,x) y = w->_maxy;  x = w->_maxx
#endif
/* HP-UX workaround */
#if defined(hpux) || defined(__hpux)
	#undef getmaxy
	#undef getmaxx
	#undef getmaxyx
	#define getmaxx __getmaxx
	#define getmaxy __getmaxy
	#define getmaxyx(__win,__y,__x) { WINDOW *__wi; __wi = __win; ((__y) = __getmaxy(__wi), (__x) = __getmaxx(__wi)); }
#endif


#if defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__)
#define off64_t off_t
#define stat64 stat
#define open64 open
#endif


#define SEL_WIN		0
#define SEL_SUBWIN	1
#define SEL_FILES	2
#define SEL_CSCHEME	3

typedef struct
{
        char *regex_str;
        regex_t regex;
        char invert_regex;
	char use_regex;

	/* command to run if matches */
	char *cmd;
} re;

typedef struct _subwindow_
{
	char *filename;
	char is_command;
	int check_interval;
	int fd;		/* read */
	int wfd;	/* write */
	pid_t pid;

	char *incomplete_line;

	char got_a_lf;

	char *win_title;

	char line_wrap;
	int line_wrap_offset;

	int win_height;

	/* repeatingly start a program */
	int restart;
	char first;
	char do_diff;
	char **bcur, **bprev;
	int ncur, nprev;

	int initial_n_lines_tail;

	char colorize;
	char field_nr;
	char *field_del;
	int color_scheme;

	char hidden;
	char follow_filename;
	char retry_open;

	time_t lastevent;
	double prev_deltat, total_deltat;
	double med;
	double dev;
	int n_events;

	WINDOW *status;
	WINDOW *data;

	int n_re;
	re *pre;

	struct _subwindow_ *next;
} proginfo;

typedef struct
{
	char **Blines;
	proginfo **pi;
	int curpos;
	char markset;
	int maxnlines;
} buffer;

typedef struct
{
	char *name;
	int n;
	int *color;
        regex_t *regex;
} color_scheme;

typedef struct
{
	int scheme_nr;
	regex_t	regex;
} scheme_per_file;

typedef struct
{
	regoff_t start;
	regoff_t end;
	int color_index;
} color_offset_in_line;

typedef struct
{
	char key;
	char *command;
} keybinding;

void do_exit(int sig);
char * select_file(char *input, int what_help);
char check_no_suppress_lines_filter(proginfo *cur);
char check_filter(proginfo *cur, char *string, regmatch_t **pmatch, char **error, int *matching_regex);
void color_print(WINDOW *win, proginfo *cur, unsigned char *string, regmatch_t *matches, int matching_regex);
int select_window(int what_help);
void toggle_colors(void);

void LOG(char *str, ...);
