#ifndef _TIFF_H
#define _TIFF_H

typedef struct {
	int ifd_tag, ifd_type, ifd_count, ifd_offset;
} IFD_entry;

typedef struct {
	const unsigned char *ifd_data;	/* Data referenced by this IFD directory. */
	int ifd_offset;		/* Offset to IFD data. */
	int ifd_count;		/* Number of entries in this IFD. */
	IFD_entry *ifd_entry;	/* Pointer to array[0..ifdcount-1] of entries. */
	int ifd_next;		/* Offset of next IFD header, or zero. */
} IFD;

#define	IFDTYPE_BYTE	1
#define	IFDTYPE_STRING	2
#define	IFDTYPE_SHORT	3
#define	IFDTYPE_LONG	4
#define	IFDTYPE_RATIONAL 5
#define	IFDTYPE_SBYTE	6
#define	IFDTYPE_UNDEFINED 7
#define	IFDTYPE_SSHORT	8
#define	IFDTYPE_SLONG	9
#define	IFDTYPE_SRATIONAL 10
#define	IFDTYPE_FLOAT 11
#define	IFDTYPE_DOUBLE 12

extern int mrw_val (const unsigned char *data, int offset, int length);
extern void mrw_setval (unsigned char *data, int offset, int length, int val);

extern const char *IFD_GetString (IFD *ifd, int tag);
extern int   IFD_GetShort (IFD *ifd, int tag);
extern int   IFD_GetLong (IFD *ifd, int tag);
extern int   IFD_GetUndefined (IFD *ifd, int tag);
extern int   IFD_GetUndefinedLength (IFD *ifd, int tag);
extern int   IFD_SetUndefinedLength (IFD *ifd, int tag, int count);
extern int   IFD_GetRational (IFD *ifd, int tag, int *num, int *denom);
extern int   IFD_GetSRational (IFD *ifd, int tag, int *num, int *denom);

extern IFD *ParseIFD (const unsigned char *data, int offset);

#endif
