#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "MRI.h"

struct MRI_SampledCurve {
	int	size;
	double	*table;
};

void
MRI_FreeSampledCurve (MRI_SampledCurve *crv)
{
	free (crv->table);
	free (crv);
}

double
MRI_SampleCurveMapValue (MRI_SampledCurve *crv, double v)
{
	int size = crv->size;
	int i;

	size--;
	v *= size;
	i = v;
	if (i < 0)
		i = 0;
	else if (i > size)
		i = size;
	return (v - i) * (crv->table[i+1]-crv->table[i]) + crv->table[i];
}

MRI_SampledCurve *
MRI_NewSampledCurve (int nsample, int n, double x[], double y[])
{
	int	i;
	int	base;
	MRI_SampledCurve *crv = malloc(sizeof(*crv));

	crv->size = nsample;
	crv->table = malloc(sizeof(double) * nsample);
	
	base = 0;
	for (i = 0; i < nsample; i++) {
		double v = i / (nsample - 1.0);
		while (base < n-1 && v >= x[base+1])
			base++;
		crv->table[i] = y[base];
		if (base < n-1)
			crv->table[i] += (v - x[base]) / (x[base+1]-x[base]) *
				     (y[base+1] - y[base]);
	}
	return crv;
}
