<?PHP //$Id: block_participants.php,v 1.5.2.2 2005/02/05 01:50:26 defacer Exp $

class CourseBlock_participants extends MoodleBlock {
    function CourseBlock_participants ($course) {
        $this->title = get_string('people');
        $this->content_type = BLOCK_TYPE_LIST;
        $this->course = $course;
        $this->version = 2004052600;
    }

    function get_content() {
        global $USER, $CFG;

        if ($this->content !== NULL) {
            return $this->content;
        }
        if (empty($this->course)) {
            $this->content = '';
            return $this->content;
        }

        $this->content = New object;
        $this->content->items = array();
        $this->content->icons = array();
        $this->content->footer = '';

        $strgroups   = get_string('groups');
        $strgroupmy  = get_string('groupmy');

        if ($this->course->category or $CFG->showsiteparticipantslist > 1 or ($CFG->showsiteparticipantslist == 1 and isteacherinanycourse()) or isteacher(SITEID)) {
            $this->content->items[]='<a title="'.get_string('listofallpeople').'" href="'.$CFG->wwwroot.'/user/index.php?id='.$this->course->id.'">'.get_string('participants').'</a>';
            $this->content->icons[]='<img src="'.$CFG->pixpath.'/i/users.gif" height="16" width="16" alt="">';
        }

        if ($this->course->groupmode or !$this->course->groupmodeforce) {
            if ($this->course->groupmode == VISIBLEGROUPS or isteacheredit($this->course->id)) {
                $this->content->items[]='<a title="'.$strgroups.'" href="'.$CFG->wwwroot.'/course/groups.php?id='.$this->course->id.'">'.$strgroups.'</a>';
                $this->content->icons[]='<img src="'.$CFG->pixpath.'/i/group.gif" height="16" width="16" alt="">';
            } else if ($this->course->groupmode == SEPARATEGROUPS and $this->course->groupmodeforce) {
                // Show nothing
            } else if ($currentgroup = get_current_group($this->course->id)) {
                $this->content->items[]='<a title="'.$strgroupmy.'" href="'.$CFG->wwwroot.'/course/group.php?id='.$this->course->id.'">'.$strgroupmy.'</a>';
                $this->content->icons[]='<img src="'.$CFG->pixpath.'/i/group.gif" height="16" width="16" alt="">';
            }
        }

        if (!empty($USER->id)) {
            $fullname = fullname($USER, true);
            $editmyprofile = '<a title="'.$fullname.'" href="'.$CFG->wwwroot.'/user/edit.php?id='.$USER->id.'&amp;course='.$this->course->id.'">'.get_string('editmyprofile').'</a>';
            if ($USER->description) {
                $this->content->items[]= $editmyprofile;
            } else {
                $this->content->items[]= $editmyprofile." <blink>*</blink>";
            }
            $this->content->icons[]='<img src="'.$CFG->pixpath.'/i/user.gif" height="16" width="16" alt="">';
        }

        return $this->content;
    }
}

?>
