/* 
 *   Creation Date: <1999/11/05 20:14:37 samuel>
 *   Time-stamp: <2002/11/24 15:14:07 samuel>
 *   
 *	<phandles.h>
 *	
 *	phandle/ihandle identifiers
 *   
 *   Copyright (C) 1999, 2002 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_PHANDLES
#define _H_PHANDLES

enum {
	molih_stdout=1,
	molih_memory,
	molih_mmu,
	molih_nvram,
	molih_rtas,
	molih_video,
	molih_kbd,
	molih_pseudofs,
	molih_blockdev,
	molih_powermgt,
#if 0
	molih_intctrl,			/* interrupt controller */
#endif
	molih__next_free		/* must be last */
};

extern mol_phandle_t 	ihandle_to_phandle( int ihandle );
extern int		ihandle_to_molih( int ihandle );
extern int		phandle_to_molih( mol_phandle_t phandle );
extern int		molih_fd_to_ihandle( int molih, int fd );

extern int		allocate_ihandle( int molih, mol_phandle_t phandle, void *data );
extern void		free_ihandle( int ihandle );
extern int		get_ihandle_data( int ihandle, void **retdata );


#endif   /* _H_PHANDLES */
