 /*******************

Written by Frank Rimlinger, Jan 1993
*******************/
#include "crossTrainer.h"

#include "FCayleyInitInfo.h"
#include <stdio.h>
#include "FGLvar.h"
#include "FCayley.h"

FCayleyInitInfo::FCayleyInitInfo(void){

// NAME
	sprintf((char *)errorStr,"Cayley"); 		// designation of GLvar for error handler
	CtoPstr((char*)errorStr);				  	// use Pascal version
	
// WALKS
	IDactiveMax=2;				// we need two simultaneously active walks
								// because the trivial words display walks Cayley
								// while the bQs algorithm is running

// PACKET SIZES	
	rNoEntries=0;				// set by bQs algorithm to number of
								// letters 	
	iNoEntries=1;
	lutNoEntries=64;			// ideal vertex look-up table
	ChildNoEntries=1064;		// child vertices generated by FGLwalkNode
	
// DATA
	useD=FALSE;
				// DtypeSize=sizeof(CGLname::D);
/* COMMENTED OUT
	useiD=TRUE;
	iDtypeSize=sizeof(FCayley::iD);
END COMMENTED OUT*/
	
// DEBUG
	useiD=FALSE;
// END DEBUG

	
// RECYCLING
	recycleBlockSize=1064;
	recycleReal=TRUE;
	recycleIdeal=TRUE;
	
// BACKYARDS
	rBackYardSize=0;
	irBackYardSize=0;
	iBackYardSize=0;
	lutBackYardSize=0;
	
// the GLref is for cloning and the Boolean is the doNotDuplicate
// flag

	rvBackYardSize=sizeof(GLref)+sizeof(Boolean); 
	
	ivBackYardSize=0;
}
