/***************************************************************************
 $RCSfile: filestream.h,v $
 -------------------
 cvs         : $Id: filestream.h,v 1.7 2003/04/08 09:38:00 aquamaniac Exp $
 begin       : Fri Dec 14 2001
 copyright   : (C) 2001 by Martin Preuss
 email       : martin@aquamaniac.de
 */


/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */



#ifndef C_FILESTREAM_H
#define C_FILESTREAM_H

#include <openhbci/error.h>
#include <openhbci/stream.h>
#include <openhbci/file.h>

namespace HBCI {

/**
 * @short This class provides a stream over a file.
 *
 * @author Martin Preuss<martin@aquamaniac.de>
 */
class DLLIMPORT FileStream : public Stream, public File {
private:
public:
  /**
   * Constructor.
   * @author Martin Preuss<martin@aquamaniac.de>
   * @param name name of the file to use
   * @param buffersize size of internal data buffer
   */
  FileStream(const string &name, unsigned int buffersize=1024);

  /**
   * Constructor for a file which uses one of StdIn, StdOut, StdErr
   * @author Martin Preuss<martin@aquamaniac.de>
   * @param typ which StdType of file to use (StdTypeStdIn etc)
   * @param buffersize size of internal data buffer
   */
  FileStream(StdType typ, unsigned int buffersize=1024);

  ~FileStream();

  /**
   * Reads data from the file.
   * This method is internally called by the Stream class and should not be called by anyone else.
   * @author Martin Preuss<martin@aquamaniac.de>
   * @param data reference to a string to receive the data read
   * @param size maximum size of the data to be received
   * @param timeout timeout for reading in seconds
   */
  void readData(string &data, unsigned int size, long timeout) {
    File::readData(data, size);
  };

  /**
   * Writes data into the file.
   * This method is internally called by the Stream class and should not be called by anyone else.
   * @author Martin Preuss<martin@aquamaniac.de>
   * @param data reference to a string to receive the data read
   * @param timeout timeout for writing in seconds
   */
  void writeData(string &data, long timeout) {
    File::writeData(data);
  };
};


} /* namespace HBCI */
#endif

