/**
 * \file xforms/FormIndex.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author Angus Leeming
 *
 * Full author contact details are available in file CREDITS
 */

#include <config.h>

#ifdef __GNUG__
#pragma implementation
#endif

#include "xformsBC.h"
#include "ControlIndex.h"
#include "FormIndex.h"
#include "forms/form_index.h"

#include "support/lstrings.h"

#include FORMS_H_LOCATION

typedef FormCB<ControlIndex, FormDB<FD_index> > base_class;

FormIndex::FormIndex()
	: base_class(_("Index"))
{}


void FormIndex::build()
{
	dialog_.reset(build_index(this));

	fl_set_input_return(dialog_->input_key, FL_RETURN_CHANGED);
	setPrehandler(dialog_->input_key);

	// Manage the ok, apply, restore and cancel/close buttons
	bc().setOK(dialog_->button_ok);
	bc().setApply(dialog_->button_apply);
	bc().setCancel(dialog_->button_close);
	bc().setRestore(dialog_->button_restore);

	bc().addReadOnly(dialog_->input_key);
}


void FormIndex::update()
{
	string const contents = trim(controller().params().getContents());
	fl_set_input(dialog_->input_key, contents.c_str());

	bc().valid(!contents.empty());
}


void FormIndex::apply()
{
	controller().params().setContents(fl_get_input(dialog_->input_key));
}
