#include <config.h>

#ifdef __GNUG__
#pragma implementation
#pragma implementation "ParameterStruct.h"
#endif

#include "ParagraphParameters.h"
#include "ParameterStruct.h"

// Initialize static member var.
ShareContainer<ParameterStruct> ParagraphParameters::container;

ParagraphParameters::ParagraphParameters()
{
	ParameterStruct tmp;
	set_from_struct(tmp);
}


void ParagraphParameters::clear()
{
	ParameterStruct tmp(*param);
	tmp.line_top = false;
	tmp.line_bottom = false;
	tmp.pagebreak_top = false;
	tmp.pagebreak_bottom = false;
	tmp.added_space_top = VSpace(VSpace::NONE);
	tmp.added_space_bottom = VSpace(VSpace::NONE);
	tmp.spacing.set(Spacing::Default);
	tmp.align = LYX_ALIGN_LAYOUT;
	tmp.depth = 0;
	tmp.noindent = false;
	tmp.labelstring.erase();
	tmp.labelwidthstring.erase();
	tmp.start_of_appendix = false;
	set_from_struct(tmp);
}


bool ParagraphParameters::sameLayout(ParagraphParameters const & pp) const
{
	return param->align == pp.param->align &&
		param->line_bottom == pp.param->line_bottom &&
		param->pagebreak_bottom == pp.param->pagebreak_bottom &&
		param->added_space_bottom == pp.param->added_space_bottom &&

		param->line_top == pp.param->line_top &&
		param->pagebreak_top == pp.param->pagebreak_top &&
		param->added_space_top == pp.param->added_space_top &&
		param->spacing == pp.param->spacing &&
		param->noindent == pp.param->noindent &&
		param->depth == pp.param->depth;
}


void ParagraphParameters::set_from_struct(ParameterStruct const & ps)
{
	// get new param from container with tmp as template
	param = container.get(ps);
}


VSpace const & ParagraphParameters::spaceTop() const
{
	return param->added_space_top;
}


void ParagraphParameters::spaceTop(VSpace const & vs)
{
	ParameterStruct tmp(*param);
	tmp.added_space_top = vs;
	set_from_struct(tmp);
}


VSpace const & ParagraphParameters::spaceBottom() const
{
	return param->added_space_bottom;
}


void ParagraphParameters::spaceBottom(VSpace const & vs)
{
	ParameterStruct tmp(*param);
	tmp.added_space_bottom = vs;
	set_from_struct(tmp);
}


Spacing const & ParagraphParameters::spacing() const
{
	return param->spacing;
}


void ParagraphParameters::spacing(Spacing const & s)
{
	ParameterStruct tmp(*param);
	tmp.spacing = s;
	set_from_struct(tmp);
}


bool ParagraphParameters::noindent() const
{
	return param->noindent;
}


void ParagraphParameters::noindent(bool ni)
{
	ParameterStruct tmp(*param);
	tmp.noindent = ni;
	set_from_struct(tmp);
}


bool ParagraphParameters::lineTop() const
{
	return param->line_top;
}


void ParagraphParameters::lineTop(bool lt)
{
	ParameterStruct tmp(*param);
	tmp.line_top = lt;
	set_from_struct(tmp);
}


bool ParagraphParameters::lineBottom() const
{
	return param->line_bottom;
}


void ParagraphParameters::lineBottom(bool lb)
{
	ParameterStruct tmp(*param);
	tmp.line_bottom = lb;
	set_from_struct(tmp);
}


bool ParagraphParameters::pagebreakTop() const
{
	return param->pagebreak_top;
}


void ParagraphParameters::pagebreakTop(bool pbt)
{
	ParameterStruct tmp(*param);
	tmp.pagebreak_top = pbt;
	set_from_struct(tmp);
}


bool ParagraphParameters::pagebreakBottom() const
{
	return param->pagebreak_bottom;
}


void ParagraphParameters::pagebreakBottom(bool pbb)
{
	ParameterStruct tmp(*param);
	tmp.pagebreak_bottom = pbb;
	set_from_struct(tmp);
}


LyXAlignment ParagraphParameters::align() const
{
	return param->align;
}


void ParagraphParameters::align(LyXAlignment la)
{
	ParameterStruct tmp(*param);
	tmp.align = la;
	set_from_struct(tmp);
}


void ParagraphParameters::depth(depth_type d)
{
	ParameterStruct tmp(*param);
	tmp.depth = d;
	set_from_struct(tmp);
}


bool ParagraphParameters::startOfAppendix() const
{
	return param->start_of_appendix;
}


void ParagraphParameters::startOfAppendix(bool soa)
{
	ParameterStruct tmp(*param);
	tmp.start_of_appendix = soa;
	set_from_struct(tmp);
}


bool ParagraphParameters::appendix() const
{
	return param->appendix;
}


void ParagraphParameters::appendix(bool a)
{
	ParameterStruct tmp(*param);
	tmp.appendix = a;
	set_from_struct(tmp);
}


string const & ParagraphParameters::labelString() const
{
	return param->labelstring;
}


void ParagraphParameters::labelString(string const & ls)
{
	ParameterStruct tmp(*param);
	tmp.labelstring = ls;
	set_from_struct(tmp);
}


string const & ParagraphParameters::labelWidthString() const
{
	return param->labelwidthstring;
}


void ParagraphParameters::labelWidthString(string const & lws)
{
	ParameterStruct tmp(*param);
	tmp.labelwidthstring = lws;
	set_from_struct(tmp);
}



LyXLength const & ParagraphParameters::leftIndent() const
{
	return param->leftindent;
}


void ParagraphParameters::leftIndent(LyXLength const & li)
{
	ParameterStruct tmp(*param);
	tmp.leftindent = li;
	set_from_struct(tmp);
}
