/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

#ifndef _SNIPES_WEAPONS_H
#define _SNIPES_WEAPONS_H

#include "coords.h"
#include "walls.h"

void init_weapons( int fcolor, int ecolor, int enable_bounce,
		   int enable_kill_wall );
void add_weapon( coordinate p, coordinate direction, int ff );
void show_weapons( screen_coords *sc );
void move_weapon( int index, screen_coords *sc, wall_info *wi );
void move_weapons( screen_coords *sc, wall_info *wi );

#endif // _SNIPES_WEAPONS_H
