import os
import gtk

class Filesel:

    def __init__(self, title, prev_location, fileops_p, multiple_p, ok_hook,
    	    	 show_p=1):
    	self.ok_hook = ok_hook
	self.filesel = gtk.FileSelection(title)
	if prev_location:
	    self.filesel.set_filename(prev_location + os.sep)
	    # We need to add the directory name separator so that
	    # the file selector opens in the directory, rather than
	    # opening the parent directory and selecting the directory
	    # there
	if fileops_p == gtk.FALSE:
	    self.filesel.hide_fileop_buttons()
    	self.filesel.cancel_button.connect("clicked", self.cancel)
    	self.filesel.ok_button.connect("clicked", self.ok)
	self.filesel.set_select_multiple(multiple_p)
	
	if show_p:
	    self.filesel.show()

    def cancel(self, *args):
    	self.filesel.destroy()
	
    def ok(self, *args):
    	filenames = self.filesel.get_selections()
	self.filesel.destroy()
	self.ok_hook(filenames)
