import gconf
import gtk


import MetaData
import TrashCan
import Window


class Model:

    def __init__(self):
	self.gconf = gconf.client_get_default()
	self.gconf.add_dir("/apps/Lodju", gconf.CLIENT_PRELOAD_NONE)
	self.windows = []
	self.trash = TrashCan.View(self)
	self.clipboard = None

    def quit(self):
	self.trash.model.doc.storage.discard()
    	gtk.main_quit()

    def get_main_window_default_size(self):
    	width = self.gconf.get_int("/apps/Lodju/saved-width")
    	height = self.gconf.get_int("/apps/Lodju/saved-height")
	return width, height

    def save_main_window_default_size(self, width, height):
    	self.gconf.set_int("/apps/Lodju/saved-width", width)
    	self.gconf.set_int("/apps/Lodju/saved-height", height)

    def get_hpaned_default_position(self):
    	return self.gconf.get_int("/apps/Lodju/saved-hpaned-position")

    def save_hpaned_default_position(self, position):
    	self.gconf.set_int("/apps/Lodju/saved-hpaned-position", position)

    def get_vpaned_default_position(self):
    	return self.gconf.get_int("/apps/Lodju/saved-vpaned-position")

    def save_vpaned_default_position(self, position):
    	self.gconf.set_int("/apps/Lodju/saved-vpaned-position", position)

    def new_window(self):
    	Window.View(self, MetaData.Document())

    def add_window(self, window):
    	self.windows.append(window)

    def remove_window(self, window):
    	self.windows.remove(window)
	if not self.windows:
	    self.quit()

    def unsaved_changes(self):
    	return map(lambda window: window.model.doc,
	    	   filter(lambda w: w.model.doc.is_dirty(), self.windows))

    def set_clipboard(self, value):
    	self.clipboard = value

    def get_clipboard(self):
    	return self.clipboard


class View:

    def __init__(self):
    	self.model = Model()
	self.controller = Controller(self.model, self)


class Controller:

    def __init__(self, model, view):
    	self.model = model
	self.view = view
