/*b
 * Copyright (C) 2001,2002,2003  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "futs.h"

/*
 * Compute the trailing portion (month,year) of the most current futures symbol
 * and append it to the prefix.  If *nowP == 0, use the current time to
 * determine which contract is most current, otherwise use the time given.
 */
void
futscode(char buf[16], char *prefix, int style, time_t *nowp)
{
	char		let = 0;
	struct tm	*tmp, thurs;

	// H=March, M=June, U=Sept, Z=Dec
	if (nowp == NULL || *nowp == 0)
	{
		time_t	tim;
		time(&tim);
		tmp = localtime(&tim);
	}
	else
		tmp = localtime(nowp);

	while (!let)
	{
		switch (tmp->tm_mon+1)
		{
		case 1: case 2:
			let = 'H'; break;
		case 4: case 5:
			let = 'M'; break;
		case 7: case 8:
			let = 'U'; break;
		case 10: case 11:
			let = 'Z'; break;
		default:
			let = 'Z'; break;
		case 3:
		case 6:
		case 9:
		case 12:
			/*
			 * Futures contracts expire on 3rd Thursday of the
			 * month.  Switch to the next contract on the 2nd
			 * Friday of the month (there is a 1 week trading
			 * overlap).
			 */
			thurs.tm_sec = 0;
			thurs.tm_min = 0;
			thurs.tm_hour = 0;
			thurs.tm_mday = 1;       /* 1-31 */
			thurs.tm_mon = tmp->tm_mon;
			thurs.tm_year = tmp->tm_year;
			mktime(&thurs);
			/* Hack alert: reverting to child's method */
			/* First Friday... */
			while (thurs.tm_wday != 5)
			{
				++thurs.tm_mday;
				++thurs.tm_wday; thurs.tm_wday %= 7;
			}
			/* Second Friday... */
			do
			{
				++thurs.tm_mday;
				++thurs.tm_wday; thurs.tm_wday %= 7;
			} while (thurs.tm_wday != 5);
			if (tmp->tm_mday < thurs.tm_mday)
				--tmp->tm_mon;
			else if (++tmp->tm_mon >= 12)
			{
				tmp->tm_mon = 0;
				++tmp->tm_year;
			}
		}
	}

	switch (style)
	{
	case FUTS_LYCOS:
	default:
		sprintf(buf, "%s%02d%c", prefix, tmp->tm_year % 100, let);
		break;
	case FUTS_SCHWAB:
		sprintf(buf, "%s%cG%d", prefix, let, tmp->tm_year % 10);
		break;
	}
}

#ifdef UNIT_TEST
main(int argc, char *argv[])
{
	time_t	now = 0;
	char	str[8];

	if (argc > 1)
		now = strtol(argv[1], (char **)NULL, 10);

	for (;;)
	{
		futscode(str, 0, &now);
		printf("%s: %ld %s", str, now, ctime(&now));
		now += 24 * 60 * 60;
	}
	exit(0);
}
#endif
