/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/


extern int	chart_command(int c, STREAMER sr);
extern void	chart_dataQ(char *buf);
extern void	chart_popup(STOCK *sp, STREAMER sr);
extern void	chart_update(STOCK *sp, QUOTE *q);

/* no abstraction for this one yet... */
extern void chart_dataQ(char *buf);

typedef struct
{
    double		open, high, low, close;
    unsigned int	volume;
} OHLCV;

/*
 * Callback from well-behaved streamer to deliver chart data
 * to the popup.
 */
void
chart_data(char *symbol, int mm, int dd, int yy, int time, OHLCV *dp);

void
chart_data_complete(int sort);

#define	FREQ_1MIN	1
#define	FREQ_5MIN	2
#define	FREQ_10MIN	3
#define	FREQ_HOUR	4
#define	FREQ_DAY	5
#define	FREQ_WEEK	6
