/***************************************************************************
                          qdom_add.h  -  description
                             -------------------
    begin                : Wed Nov 21 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QDOM_ADD_H
#define QDOM_ADD_H

/** This file contains useful datatypes and functions in addition to the Qt DOM classes. */

#include <qpixmap.h>
#include <qdom.h>

class KXESearchDialog;

extern QPixmap g_iconElement;
extern QPixmap g_iconText;
extern QPixmap g_iconComment;
extern QPixmap g_iconCDATASection;
extern QPixmap g_iconProcessingInstruction;
extern QPixmap g_iconElement_b;
extern QPixmap g_iconText_b;
extern QPixmap g_iconComment_b;
extern QPixmap g_iconCDATASection_b;
extern QPixmap g_iconProcessingInstruction_b;

/** Returns the corresponding pixmap/icon to the given node type. */
const QPixmap & domTool_getIconForNodeType( QDomNode::NodeType type, bool );

/** Returns the path of the given node. */
QString domTool_getPath( const QDomNode & );

/** Returns the path of the given node. */
QString domTool_getPath( const QDomElement & );

/** Returns the level (how deep in tree) of the given node. */
unsigned int domTool_getLevel( const QDomNode & );

/** Returns a QString with the XML representation of the given node including all its children (uses @ref QDomNode::save). */
QString domTool_save( const QDomNode &, int );

/**
 * Returns the previous node of the given one or an empty node, if it is the first.
 * This will be its previous siblings last grand child, if there is one.
 * Otherwise it is the previous sibling or,
 * if there is no sibling above, it will be its parent or
 * an empty node (if there is no parent).
 */
QDomNode domTool_prevNode( const QDomNode & node );
/**
 * Returns the next node of the given one or an empty node, if it is the last.
 * This will be it's first child,
 * if there are no childs, it will be the next sibling
 * and if there are no siblings below, it will be the parent's next sibling ...
 */
QDomNode domTool_nextNode( const QDomNode & node );

/**
 * Tests the given node and its (grand)childs.
 * Returns the node, which matches the given path, oran empty node (if no one matches).
 */
QDomNode domTool_matchingNode( const QDomNode & node, const QString & szPath );

/** Tests, if the given node matches the conditions of the given search. */
bool domTool_match( QDomNode node, const KXESearchDialog * const pConditions );

#endif

