/***************************************************************************
                          kxesearchdialog.cpp  -  description
                          -------------------
    begin                : Tue Jul 10 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxesearchdialog.h"

#include <qpushbutton.h>

KXESearchDialog::KXESearchDialog(QWidget *parent, const char *name, bool modal)
	: KXESearchDialogBase(parent, name, modal)
{
	m_pPushButtonFind->setEnabled(false);
	m_pEditSearchedString->setFocus();
	m_pPushButtonFind->setDefault(true);
}

void KXESearchDialog::slotTextChanged(const QString& string)
{
	if ( string.isEmpty() )
		m_pPushButtonFind->setEnabled(false);
	else
		m_pPushButtonFind->setEnabled(true);

	toggleAcceptButton();
}

void KXESearchDialog::slotFindInChanged()
{
	toggleAcceptButton();
}

void KXESearchDialog::toggleAcceptButton()
{
	if ( (m_pCheckBoxElementNames->isChecked()) ||(m_pCheckBoxAttributeNames->isChecked()) || (m_pCheckBoxAttributeValues->isChecked()) || (m_pCheckBoxContents->isChecked()) )
	{
		if ( m_pEditSearchedString->text().isEmpty() )
			m_pPushButtonFind->setEnabled(false);
		else
			m_pPushButtonFind->setEnabled(true);
	}
	else
		m_pPushButtonFind->setEnabled(false);
}
