#ifndef DSPOUTALSA_H_INCLUDED
#define DSPOUTALSA_H_INCLUDED

//#include <sys/soundcard.h>
#include <alsa/asoundlib.h>
#include "dspout.h"

/**
 * @short OSS implementation of DspOut.
 * @author Billy Biggs <vektor@div8.net>
 *
 * This is the OSS implementation of DspOut for the /dev/dsp*
 * devices.  Note that you cannot change how many fragments
 * this class requests, yet.
 */
class DspOutAlsa : public DspOut
{
public:
	/**
	 * Constructs a DspOutAlsa object representing the given
	 * filename.  Default is /dev/dsp.
	 */
	DspOutAlsa( const QString &fileName = "hw:0,0" );

	/**
	 * Destructor.  Will close the device if it is open.
	 */
	virtual ~DspOutAlsa( void );

	bool openDevice( DeviceMode mode );
//	bool openDevice( int exist_fs );
	bool writeBuffer( void );
	unsigned int readableBytes( void );
	bool readBuffer( int bytes );
	int audio_fd;

private:
	
	unsigned int rate; 
	int exact_rate;
	int dir;

	int err;
	snd_pcm_t *handle;
	snd_pcm_hw_params_t *hw_params;
	snd_pcm_uframes_t buffer_size;



//	AudioBuffer output_buf;   // Output buffer
	QString devname;         // device filename
};

#endif  // DSPOUTOSS_H_INCLUDED
