/*******************************************************************************
**                              konservedebug.h
**                                 part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef KONSERVEDEBUG_H
#define KONSERVEDEBUG_H

// Qt includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>

class LogEntry
{
public:
    LogEntry(QString funcName) :  functionName(funcName), prefix()
        {
            indentation += 2;
            for (int j = 0; j < indentation; ++j)
                prefix.append(" ");
            kdDebug(0) << prefix << "+++ " << functionName << endl;
        }

    ~LogEntry() {
        kdDebug(0) << prefix << "--- " << functionName << endl;
        indentation -= 2;
    }

private:
    static int  indentation;
    QString     functionName;
    QString     prefix;
};

#ifdef __GNUC__
#define TRACE() LogEntry log(__PRETTY_FUNCTION__);
#else
#define TRACE()
#endif

#define DUMP(a) kdDebug(0) << #a << ": " << (a) << endl;
#define PRINT(a) kdDebug(0) << a << endl;
#endif
