/***************************************************************************
                          debugoutput.cpp  -  description
                             -------------------
    begin                : Sun Apr 30 2000
    copyright            : (C) 2000 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "debugoutput.h"

DebugOutput::DebugOutput (QWidget * parent, const char *name):
DebugOutputDlg (parent, name, false)
{
  setCaption ("Debug");
  connect (closeBtn, SIGNAL (clicked ()), this, SLOT (hideWindow ()));

}

DebugOutput::~DebugOutput ()
{
}

/** adds text to the MultilineEditwidget */
void
DebugOutput::addOutputText (const QString & text)
{
  output_edit->append (text);
}

/**  */
void
DebugOutput::SetTitle (const QString & text)
{
  setCaption (text);
}

/**  */
void
DebugOutput::hideWindow ()
{
  emit isClosed (this);
}
